/*
 * Decompiled with CFR 0.152.
 */
package MarcSync;

import MarcSync.Collection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class Client {
    private final String _accessToken;

    public Client(String accessToken) {
        this._accessToken = accessToken;
    }

    public Collection getCollection(String collectionName) {
        return new Collection(this._accessToken, collectionName);
    }

    public Collection fetchCollection(String collectionName) throws IOException, URISyntaxException {
        URL url = new URI("https://api.marcsync.dev/v0/collection/" + collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to fetch collection: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return new Collection(this._accessToken, collectionName);
    }

    public Collection createCollection(String collectionName) throws IOException, URISyntaxException {
        URL url = new URI("https://api.marcsync.dev/v0/collection/" + collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to create collection: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return new Collection(this._accessToken, collectionName);
    }
}

