/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.config;

import flysql.domain.license.server.enforcer.LicensePostBlockFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.web.server.WebFilter;

@Configuration
@EnableWebFluxSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lflysql/api/config/SecurityConfig;", "", "licensePostBlockFilter", "Lflysql/domain/license/server/enforcer/LicensePostBlockFilter;", "(Lflysql/domain/license/server/enforcer/LicensePostBlockFilter;)V", "security", "Lorg/springframework/security/web/server/SecurityWebFilterChain;", "http", "Lorg/springframework/security/config/web/server/ServerHttpSecurity;", "flysql-executor"})
public class SecurityConfig {
    @NotNull
    private final LicensePostBlockFilter licensePostBlockFilter;

    public SecurityConfig(@NotNull LicensePostBlockFilter licensePostBlockFilter) {
        Intrinsics.checkNotNullParameter((Object)licensePostBlockFilter, (String)"licensePostBlockFilter");
        this.licensePostBlockFilter = licensePostBlockFilter;
    }

    @Bean
    @NotNull
    public SecurityWebFilterChain security(@NotNull ServerHttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        SecurityWebFilterChain securityWebFilterChain = http.csrf(SecurityConfig::security$lambda$0).addFilterAt((WebFilter)this.licensePostBlockFilter, SecurityWebFiltersOrder.FIRST).authorizeExchange(SecurityConfig::security$lambda$1).headers(SecurityConfig::security$lambda$4).build();
        Intrinsics.checkNotNullExpressionValue((Object)securityWebFilterChain, (String)"build(...)");
        return securityWebFilterChain;
    }

    private static final void security$lambda$0(ServerHttpSecurity.CsrfSpec it) {
        it.disable();
    }

    private static final void security$lambda$1(ServerHttpSecurity.AuthorizeExchangeSpec exchanges) {
        String[] stringArray = new String[]{"/actuator/health/**"};
        ServerHttpSecurity.AuthorizeExchangeSpec authorizeExchangeSpec = ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchanges.pathMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/webjars/swagger-ui/**"};
        ServerHttpSecurity.AuthorizeExchangeSpec authorizeExchangeSpec2 = ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/v3/api-docs/**"};
        ServerHttpSecurity.AuthorizeExchangeSpec authorizeExchangeSpec3 = ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec2.pathMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/**"};
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec3.pathMatchers(stringArray)).permitAll();
    }

    private static final void security$lambda$4$lambda$2(ServerHttpSecurity.HeaderSpec.FrameOptionsSpec it) {
        it.disable();
    }

    private static final void security$lambda$4$lambda$3(ServerHttpSecurity.HeaderSpec.ContentSecurityPolicySpec csp) {
        csp.policyDirectives(StringsKt.replace$default((String)"frame-ancestors \n  https://testingautomation.dev \n  https://www.testingautomation.dev", (String)"\n", (String)" ", (boolean)false, (int)4, null));
    }

    private static final void security$lambda$4(ServerHttpSecurity.HeaderSpec headers) {
        headers.frameOptions(SecurityConfig::security$lambda$4$lambda$2);
        headers.contentSecurityPolicy(SecurityConfig::security$lambda$4$lambda$3);
    }
}

