/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.controller;

import flysql.api.controller.DockerTagController;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@RestController
@RequestMapping(value={"/api/v1/docker"})
@CrossOrigin(origins={"*"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0017R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lflysql/api/controller/DockerTagController;", "", "()V", "cache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lflysql/api/controller/DockerTagController$CachedResponse;", "cacheTtlSeconds", "", "dockerHubApi", "", "repository", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "getTags", "Lorg/springframework/http/ResponseEntity;", "CachedResponse", "flysql-executor"})
public class DockerTagController {
    @NotNull
    private final String repository;
    private final long cacheTtlSeconds;
    @NotNull
    private final String dockerHubApi;
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final AtomicReference<CachedResponse> cache;

    public DockerTagController() {
        this.repository = "rainerglueck/flysql";
        this.cacheTtlSeconds = 3600L;
        this.dockerHubApi = "https://hub.docker.com/v2/repositories/" + this.repository + "/tags?page_size=5";
        this.restTemplate = new RestTemplate();
        this.cache = new AtomicReference<Object>(null);
        this.restTemplate.setUriTemplateHandler((UriTemplateHandler)new DefaultUriBuilderFactory());
    }

    @GetMapping(value={"/tags"})
    @NotNull
    public ResponseEntity<String> getTags() {
        ResponseEntity responseEntity;
        boolean cacheIsValid;
        long now = Instant.now().getEpochSecond();
        CachedResponse cached = (CachedResponse)this.cache.get();
        boolean bl = cacheIsValid = cached != null && now - cached.getTimestamp() < this.cacheTtlSeconds;
        if (cacheIsValid) {
            CachedResponse cachedResponse = cached;
            Intrinsics.checkNotNull((Object)cachedResponse);
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)cachedResponse.getData());
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"ok(...)");
        } else {
            ResponseEntity responseEntity3;
            try {
                String response = (String)this.restTemplate.getForObject(this.dockerHubApi, String.class, new Object[0]);
                String string = response;
                if (string == null) {
                    string = "{}";
                }
                this.cache.set(new CachedResponse(string, now));
                responseEntity3 = ResponseEntity.ok((Object)response);
            }
            catch (Exception e) {
                responseEntity3 = cached == null ? ResponseEntity.internalServerError().body((Object)("{\"error\":\"Failed to fetch Docker tags: " + e.getMessage() + "\"}")) : ResponseEntity.ok((Object)cached.getData());
            }
            ResponseEntity responseEntity4 = responseEntity3;
            Intrinsics.checkNotNull((Object)responseEntity4);
            responseEntity = responseEntity4;
        }
        return responseEntity;
    }
}

