/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.controller.sqlQuery;

import flysql.api.controller.sqlQuery.AbstractSqlQueryController;
import flysql.api.dto.SqlQueryRequestDto;
import flysql.api.dto.SqlQueryResponseDto;
import flysql.api.service.DbConnectionConfigLookupService;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.DbType;
import flysql.domain.models.SqlQuery;
import flysql.domain.models.SqlQueryResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lflysql/api/controller/sqlQuery/AbstractSqlQueryController;", "", "lookupService", "Lflysql/api/service/DbConnectionConfigLookupService;", "queryExecutor", "Lkotlin/Function1;", "Lflysql/domain/models/SqlQuery;", "Lflysql/domain/models/SqlQueryResult;", "dbType", "Lflysql/domain/models/DbType;", "(Lflysql/api/service/DbConnectionConfigLookupService;Lkotlin/jvm/functions/Function1;Lflysql/domain/models/DbType;)V", "executeQuery", "dbName", "", "dto", "Lflysql/api/dto/SqlQueryRequestDto;", "executeQuery$flysql_executor", "fetchScalar", "Lreactor/core/publisher/Mono;", "fetchSqlQueryResult", "Lflysql/api/dto/SqlQueryResponseDto;", "flysql-executor"})
public abstract class AbstractSqlQueryController {
    @NotNull
    private final DbConnectionConfigLookupService lookupService;
    @NotNull
    private final Function1<SqlQuery, SqlQueryResult> queryExecutor;
    @NotNull
    private final DbType dbType;

    public AbstractSqlQueryController(@NotNull DbConnectionConfigLookupService lookupService, @NotNull Function1<? super SqlQuery, SqlQueryResult> queryExecutor, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)lookupService, (String)"lookupService");
        Intrinsics.checkNotNullParameter(queryExecutor, (String)"queryExecutor");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        this.lookupService = lookupService;
        this.queryExecutor = queryExecutor;
        this.dbType = dbType;
    }

    @NotNull
    public final Mono<SqlQueryResponseDto> fetchSqlQueryResult(@NotNull String dbName, @NotNull SqlQueryRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Mono mono = Mono.fromCallable(() -> AbstractSqlQueryController.fetchSqlQueryResult$lambda$0(this, dbName, dto)).map(arg_0 -> AbstractSqlQueryController.fetchSqlQueryResult$lambda$1((Function1)fetchSqlQueryResult.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<Object> fetchScalar(@NotNull String dbName, @NotNull SqlQueryRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Mono mono = Mono.fromCallable(() -> AbstractSqlQueryController.fetchScalar$lambda$2(this, dbName, dto)).mapNotNull(arg_0 -> AbstractSqlQueryController.fetchScalar$lambda$3((Function1)fetchScalar.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    @NotNull
    public final SqlQueryResult executeQuery$flysql_executor(@NotNull String dbName, @NotNull SqlQueryRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        DbConnectionConfig dbConnectionConfig = this.lookupService.findDbByNameAndType(dbName, this.dbType);
        SqlQuery sqlQuery = SqlQueryRequestDto.Companion.create(dbConnectionConfig, dto);
        return (SqlQueryResult)this.queryExecutor.invoke((Object)sqlQuery);
    }

    private static final SqlQueryResult fetchSqlQueryResult$lambda$0(AbstractSqlQueryController this$0, String $dbName, SqlQueryRequestDto $dto) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dbName, (String)"$dbName");
        Intrinsics.checkNotNullParameter((Object)$dto, (String)"$dto");
        return this$0.executeQuery$flysql_executor($dbName, $dto);
    }

    private static final SqlQueryResponseDto fetchSqlQueryResult$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SqlQueryResponseDto)$tmp0.invoke(p0);
    }

    private static final SqlQueryResult fetchScalar$lambda$2(AbstractSqlQueryController this$0, String $dbName, SqlQueryRequestDto $dto) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dbName, (String)"$dbName");
        Intrinsics.checkNotNullParameter((Object)$dto, (String)"$dto");
        return this$0.executeQuery$flysql_executor($dbName, $dto);
    }

    private static final Object fetchScalar$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }
}

