/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.controller.sqlQuery;

import flysql.api.controller.sqlQuery.AbstractSqlQueryController;
import flysql.api.dto.SqlQueryRequestDto;
import flysql.api.dto.SqlQueryResponseDto;
import flysql.api.service.DbConnectionConfigLookupService;
import flysql.domain.models.DbType;
import flysql.domain.usecases.SqlQueryExecutor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/v1/sql"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lflysql/api/controller/sqlQuery/SqlQueryExecutionController;", "Lflysql/api/controller/sqlQuery/AbstractSqlQueryController;", "sqlQueryExecutor", "Lflysql/domain/usecases/SqlQueryExecutor;", "lookupService", "Lflysql/api/service/DbConnectionConfigLookupService;", "(Lflysql/domain/usecases/SqlQueryExecutor;Lflysql/api/service/DbConnectionConfigLookupService;)V", "executeSql", "Lreactor/core/publisher/Mono;", "Lflysql/api/dto/SqlQueryResponseDto;", "sqldbname", "", "dto", "Lflysql/api/dto/SqlQueryRequestDto;", "executeSqlScalar", "", "flysql-executor"})
public class SqlQueryExecutionController
extends AbstractSqlQueryController {
    @NotNull
    private final SqlQueryExecutor sqlQueryExecutor;

    public SqlQueryExecutionController(@NotNull SqlQueryExecutor sqlQueryExecutor, @NotNull DbConnectionConfigLookupService lookupService) {
        Intrinsics.checkNotNullParameter((Object)sqlQueryExecutor, (String)"sqlQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)lookupService, (String)"lookupService");
        super(lookupService, (Function1)new /* Unavailable Anonymous Inner Class!! */, DbType.SQL);
        this.sqlQueryExecutor = sqlQueryExecutor;
    }

    @PostMapping(value={"/{sqldbname}"}, consumes={"application/json"})
    @NotNull
    public Mono<SqlQueryResponseDto> executeSql(@PathVariable @NotNull String sqldbname, @RequestBody @NotNull SqlQueryRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)sqldbname, (String)"sqldbname");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return this.fetchSqlQueryResult(sqldbname, dto);
    }

    @PostMapping(value={"/{sqldbname}/scalar"}, consumes={"application/json"})
    @NotNull
    public Mono<Object> executeSqlScalar(@PathVariable @NotNull String sqldbname, @RequestBody @NotNull SqlQueryRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)sqldbname, (String)"sqldbname");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return this.fetchScalar(sqldbname, dto);
    }
}

