/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.service;

import flysql.api.dto.AboutInfoDto;
import flysql.api.dto.LicenseRestrictionDtoFactory;
import flysql.api.dto.UseCaseRestrictionsDto;
import flysql.api.service.FlySqlApp;
import flysql.domain.license.config.LicenseConfig;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B!\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0011R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lflysql/api/service/AboutService;", "", "activeProfile", "", "flySqlApp", "Lflysql/api/service/FlySqlApp;", "licenseConfig", "Lflysql/domain/license/config/LicenseConfig;", "(Ljava/lang/String;Lflysql/api/service/FlySqlApp;Lflysql/domain/license/config/LicenseConfig;)V", "restrictions", "", "", "Lflysql/api/dto/UseCaseRestrictionsDto;", "about", "Lflysql/api/dto/AboutInfoDto;", "getShowAvailableDockerTags", "", "getShowAvailableDockerTags$flysql_executor", "flysql-executor"})
public class AboutService {
    @Nullable
    private final String activeProfile;
    @NotNull
    private final FlySqlApp flySqlApp;
    @NotNull
    private final LicenseConfig licenseConfig;
    @NotNull
    private final Map<String, List<UseCaseRestrictionsDto>> restrictions;

    public AboutService(@Value(value="${spring.profiles.active:}") @Nullable String activeProfile, @NotNull FlySqlApp flySqlApp, @NotNull LicenseConfig licenseConfig) {
        Intrinsics.checkNotNullParameter((Object)flySqlApp, (String)"flySqlApp");
        Intrinsics.checkNotNullParameter((Object)licenseConfig, (String)"licenseConfig");
        this.activeProfile = activeProfile;
        this.flySqlApp = flySqlApp;
        this.licenseConfig = licenseConfig;
        this.restrictions = LicenseRestrictionDtoFactory.INSTANCE.getRestrictions();
    }

    @NotNull
    public AboutInfoDto about() {
        String string = this.flySqlApp.getImageTag();
        if (string == null) {
            string = "";
        }
        return new AboutInfoDto(string, this.licenseConfig.license(), this.restrictions, this.getShowAvailableDockerTags$flysql_executor());
    }

    public boolean getShowAvailableDockerTags$flysql_executor() {
        return Intrinsics.areEqual((Object)this.activeProfile, (Object)"docker") ? this.flySqlApp.getShowAvailableDockerTags() : true;
    }
}

