/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.service;

import flysql.dbconnection.CombinedDbRegistry;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.DbType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lflysql/api/service/DbConnectionConfigLookupService;", "", "combinedDbRegistry", "Lflysql/dbconnection/CombinedDbRegistry;", "(Lflysql/dbconnection/CombinedDbRegistry;)V", "findDbByNameAndType", "Lflysql/domain/models/DbConnectionConfig;", "name", "", "dbType", "Lflysql/domain/models/DbType;", "flysql-executor"})
public class DbConnectionConfigLookupService {
    @NotNull
    private final CombinedDbRegistry combinedDbRegistry;

    public DbConnectionConfigLookupService(@NotNull CombinedDbRegistry combinedDbRegistry) {
        Intrinsics.checkNotNullParameter((Object)combinedDbRegistry, (String)"combinedDbRegistry");
        this.combinedDbRegistry = combinedDbRegistry;
    }

    @NotNull
    public DbConnectionConfig findDbByNameAndType(@NotNull String name, @Nullable DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DbConnectionConfig dbConnectionConfig = this.combinedDbRegistry.findDbByName(name, dbType);
        if (dbConnectionConfig == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.combinedDbRegistry.displayDatabases(dbType));
        }
        return dbConnectionConfig;
    }
}

