/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.license.models;

import flysql.domain.license.config.LicenseConfig;
import flysql.domain.license.models.LicenseType;
import flysql.domain.license.models.restrictions.NumberOfColumnsRestriction;
import flysql.domain.license.models.restrictions.NumberOfRowsRestriction;
import flysql.domain.models.SqlQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lflysql/domain/license/models/SqlDataReducer;", "", "licenseConfig", "Lflysql/domain/license/config/LicenseConfig;", "(Lflysql/domain/license/config/LicenseConfig;)V", "columnRestriction", "Lflysql/domain/license/models/restrictions/NumberOfColumnsRestriction;", "rowRestriction", "Lflysql/domain/license/models/restrictions/NumberOfRowsRestriction;", "reduceResultSet", "Lflysql/domain/models/SqlQueryResult;", "sqlQueryResult", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nSqlDataReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDataReducer.kt\nflysql/domain/license/models/SqlDataReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,32:1\n1549#2:33\n1620#2,2:34\n1622#2:43\n478#3,7:36\n*S KotlinDebug\n*F\n+ 1 SqlDataReducer.kt\nflysql/domain/license/models/SqlDataReducer\n*L\n23#1:33\n23#1:34,2\n23#1:43\n24#1:36,7\n*E\n"})
public class SqlDataReducer {
    @NotNull
    private final LicenseConfig licenseConfig;
    @NotNull
    private final NumberOfColumnsRestriction columnRestriction;
    @NotNull
    private final NumberOfRowsRestriction rowRestriction;

    public SqlDataReducer(@NotNull LicenseConfig licenseConfig) {
        Intrinsics.checkNotNullParameter((Object)licenseConfig, (String)"licenseConfig");
        this.licenseConfig = licenseConfig;
        this.columnRestriction = NumberOfColumnsRestriction.INSTANCE;
        this.rowRestriction = NumberOfRowsRestriction.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SqlQueryResult reduceResultSet(@NotNull SqlQueryResult sqlQueryResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sqlQueryResult, (String)"sqlQueryResult");
        LicenseType licenseType = this.licenseConfig.license().getType();
        List limitedColumns = (List)this.columnRestriction.getRestriction().enforce(licenseType, (Object)sqlQueryResult.getColumnNames());
        List limitedRows = (List)this.rowRestriction.getRestriction().enforce(licenseType, (Object)sqlQueryResult.getRows());
        Iterable $this$map$iv = limitedRows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void row;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$filterKeys$iv = row;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!limitedColumns.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            collection.add((Map)result$iv);
        }
        List reducedRows = (List)destination$iv$iv;
        return new SqlQueryResult(limitedColumns, reducedRows);
    }
}

