/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.license.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import flysql.domain.license.models.License;
import flysql.domain.license.models.LicenseAndBytes;
import flysql.domain.license.server.LicenseObjectMapper;
import flysql.domain.license.server.LicenseParser;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lflysql/domain/license/server/LicenseParser;", "", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "decode", "", "jsonBase64", "", "mapStringToLicense", "Lflysql/domain/license/models/License;", "jsonString", "errorHint", "parseFromBase64", "parseFromBase64ToJsonString", "parseFromPath", "Lflysql/domain/license/models/LicenseAndBytes;", "Ljava/nio/file/Path;", "parseToLicenseAndBytes", "path", "printPretty", "", "sanitizeBase64String", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nLicenseParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseParser.kt\nflysql/domain/license/server/LicenseParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class LicenseParser {
    @NotNull
    public static final LicenseParser INSTANCE = new LicenseParser();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final ObjectMapper mapper = LicenseObjectMapper.INSTANCE.getMapper();

    private LicenseParser() {
    }

    @NotNull
    public final byte[] decode(@NotNull String jsonBase64) {
        Intrinsics.checkNotNullParameter((Object)jsonBase64, (String)"jsonBase64");
        byte[] byArray = Base64.getDecoder().decode(this.sanitizeBase64String(jsonBase64));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @Nullable
    public final License parseFromBase64(@NotNull String jsonBase64) {
        License license2;
        String jsonString;
        Intrinsics.checkNotNullParameter((Object)jsonBase64, (String)"jsonBase64");
        String string = jsonString = this.parseFromBase64ToJsonString(jsonBase64);
        if (string != null) {
            String it = string;
            boolean bl = false;
            license2 = INSTANCE.mapStringToLicense(jsonString, "from base64 string");
        } else {
            license2 = null;
        }
        return license2;
    }

    @Nullable
    public final LicenseAndBytes parseFromPath(@NotNull Path jsonBase64) {
        Intrinsics.checkNotNullParameter((Object)jsonBase64, (String)"jsonBase64");
        return this.parseToLicenseAndBytes(jsonBase64);
    }

    public final void printPretty(@NotNull String jsonBase64) {
        Intrinsics.checkNotNullParameter((Object)jsonBase64, (String)"jsonBase64");
        String jsonString = this.parseFromBase64ToJsonString(jsonBase64);
        JsonNode jsonNode = mapper.readTree(jsonString);
        String prettyJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        System.out.println((Object)prettyJson);
    }

    private final License mapStringToLicense(String jsonString, String errorHint) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                LicenseParser $this$mapStringToLicense_u24lambda_u241 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)((License)mapper.readValue(jsonString, License.class)));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            logger.error((Throwable)it, (Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        return (License)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String parseFromBase64ToJsonString(String jsonBase64) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                LicenseParser $this$parseFromBase64ToJsonString_u24lambda_u243 = object;
                boolean bl = false;
                byte[] decodedBytes = $this$parseFromBase64ToJsonString_u24lambda_u243.decode(jsonBase64);
                object2 = Result.constructor-impl((Object)new String(decodedBytes, Charsets.UTF_8));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            logger.error((Function0)new /* Unavailable Anonymous Inner Class!! */);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final LicenseAndBytes parseToLicenseAndBytes(Path path) {
        LicenseAndBytes licenseAndBytes;
        if (!path.toFile().exists()) {
            logger.error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            licenseAndBytes = null;
        } else {
            License license2;
            String jsonBase64 = Files.readString(path);
            Intrinsics.checkNotNull((Object)jsonBase64);
            byte[] byteArray = this.decode(jsonBase64);
            License license3 = license2 = this.mapStringToLicense(new String(byteArray, Charsets.UTF_8), "from path " + path);
            if (license3 != null) {
                License it = license3;
                boolean bl = false;
                licenseAndBytes = new LicenseAndBytes(byteArray, it);
            } else {
                licenseAndBytes = null;
            }
        }
        return licenseAndBytes;
    }

    private final String sanitizeBase64String(String jsonBase64) {
        CharSequence charSequence = jsonBase64;
        Regex regex = new Regex("\\s");
        String string = "";
        return regex.replace(charSequence, string);
    }
}

