/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.license.server.enforcer;

import flysql.domain.license.config.LicenseConfig;
import flysql.domain.license.models.LicenseType;
import flysql.domain.license.models.restrictions.LicenseRestriction;
import flysql.domain.license.models.restrictions.PostRequestRestriction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lflysql/domain/license/server/enforcer/LicensePostBlockFilter;", "Lorg/springframework/web/server/WebFilter;", "licenseConfig", "Lflysql/domain/license/config/LicenseConfig;", "(Lflysql/domain/license/config/LicenseConfig;)V", "restriction", "Lflysql/domain/license/models/restrictions/LicenseRestriction;", "Lorg/springframework/web/server/ServerWebExchange;", "", "filter", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "chain", "Lorg/springframework/web/server/WebFilterChain;", "flysql-executor"})
public class LicensePostBlockFilter
implements WebFilter {
    @NotNull
    private final LicenseConfig licenseConfig;
    @NotNull
    private final LicenseRestriction<ServerWebExchange, Boolean> restriction;

    public LicensePostBlockFilter(@NotNull LicenseConfig licenseConfig) {
        Intrinsics.checkNotNullParameter((Object)licenseConfig, (String)"licenseConfig");
        this.licenseConfig = licenseConfig;
        this.restriction = PostRequestRestriction.INSTANCE.getRestriction();
    }

    @NotNull
    public Mono<Void> filter(@NotNull ServerWebExchange exchange, @NotNull WebFilterChain chain) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        LicenseType licenseType = this.licenseConfig.license().getType();
        boolean allowed = (Boolean)this.restriction.enforce(licenseType, (Object)exchange);
        if (allowed) {
            Mono mono2 = chain.filter(exchange);
            Intrinsics.checkNotNull((Object)mono2);
            mono = mono2;
        } else {
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN);
            String msg = "Request not allowed for your license";
            DataBufferFactory dataBufferFactory = exchange.getResponse().bufferFactory();
            Intrinsics.checkNotNullExpressionValue((Object)dataBufferFactory, (String)"bufferFactory(...)");
            DataBufferFactory bufferFactory = dataBufferFactory;
            String string = msg;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            DataBuffer dataBuffer = bufferFactory.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"wrap(...)");
            DataBuffer buffer = dataBuffer;
            Mono mono3 = exchange.getResponse().writeWith((Publisher)Mono.just((Object)buffer));
            Intrinsics.checkNotNull((Object)mono3);
            mono = mono3;
        }
        return mono;
    }
}

