/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.service;

import flysql.domain.factories.BufferStatementFactory;
import flysql.domain.factories.DoDynStatementFactory;
import flysql.domain.models.AvaloqScriptQuery;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.service.AvaloqScriptExecutorService;
import flysql.domain.service.DbExecutor;
import flysql.domain.usecases.AvaloqScriptExecutor;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!render"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J%\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lflysql/domain/service/AvaloqScriptExecutorService;", "Lflysql/domain/usecases/AvaloqScriptExecutor;", "dbExecutor", "Lflysql/domain/service/DbExecutor;", "(Lflysql/domain/service/DbExecutor;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "clobToString", "", "cl", "Ljava/sql/Clob;", "execute", "avaloqScriptQuery", "Lflysql/domain/models/AvaloqScriptQuery;", "executeScript", "conn", "Ljava/sql/Connection;", "avaloqScript", "avaloqUser", "executeScript$flysql_executor", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nAvaloqScriptExecutorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvaloqScriptExecutorService.kt\nflysql/domain/service/AvaloqScriptExecutorService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public class AvaloqScriptExecutorService
implements AvaloqScriptExecutor {
    @NotNull
    private final DbExecutor dbExecutor;
    @NotNull
    private final KLogger logger;

    public AvaloqScriptExecutorService(@NotNull DbExecutor dbExecutor) {
        Intrinsics.checkNotNullParameter((Object)dbExecutor, (String)"dbExecutor");
        this.dbExecutor = dbExecutor;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public String execute(@NotNull AvaloqScriptQuery avaloqScriptQuery) {
        Intrinsics.checkNotNullParameter((Object)avaloqScriptQuery, (String)"avaloqScriptQuery");
        DbConnectionConfig dbConnectionConfig = avaloqScriptQuery.getDbConnectionConfig();
        return (String)this.dbExecutor.executeWithConnection(dbConnectionConfig, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String executeScript$flysql_executor(@NotNull Connection conn, @NotNull String avaloqScript, @NotNull String avaloqUser) {
        CallableStatement cstmt2;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)avaloqScript, (String)"avaloqScript");
        Intrinsics.checkNotNullParameter((Object)avaloqUser, (String)"avaloqUser");
        int bufferNumber = 0;
        String result = null;
        Ref.ObjectRef statement = new Ref.ObjectRef();
        statement.element = BufferStatementFactory.INSTANCE.openSessionStatement();
        AutoCloseable autoCloseable = conn.prepareCall((String)statement.element);
        Throwable throwable = null;
        try {
            cstmt2 = (CallableStatement)autoCloseable;
            boolean bl = false;
            cstmt2.execute();
            this.logger.debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            cstmt2 = Unit.INSTANCE;
        }
        catch (Throwable cstmt2) {
            throwable = cstmt2;
            throw cstmt2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        statement.element = BufferStatementFactory.INSTANCE.createStatement();
        autoCloseable = conn.prepareCall((String)statement.element);
        throwable = null;
        try {
            cstmt2 = (CallableStatement)autoCloseable;
            boolean bl = false;
            cstmt2.registerOutParameter(1, 4);
            cstmt2.execute();
            bufferNumber = cstmt2.getInt(1);
            this.logger.debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            cstmt2 = Unit.INSTANCE;
        }
        catch (Throwable cstmt3) {
            throwable = cstmt3;
            throw cstmt3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        statement.element = DoDynStatementFactory.INSTANCE.create(bufferNumber, avaloqScript, avaloqUser);
        autoCloseable = conn.prepareCall((String)statement.element);
        throwable = null;
        try {
            cstmt2 = (CallableStatement)autoCloseable;
            boolean bl = false;
            cstmt2.execute();
            this.logger.debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            cstmt2 = Unit.INSTANCE;
        }
        catch (Throwable cstmt4) {
            throwable = cstmt4;
            throw cstmt4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        statement.element = BufferStatementFactory.INSTANCE.getValueStatement(bufferNumber);
        autoCloseable = conn.prepareCall((String)statement.element);
        throwable = null;
        try {
            cstmt2 = (CallableStatement)autoCloseable;
            boolean bl = false;
            cstmt2.registerOutParameter(1, 2005);
            cstmt2.execute();
            Clob clob = cstmt2.getClob(1);
            Intrinsics.checkNotNullExpressionValue((Object)clob, (String)"getClob(...)");
            result = this.clobToString(clob);
            this.logger.debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            cstmt2 = Unit.INSTANCE;
        }
        catch (Throwable cstmt5) {
            throwable = cstmt5;
            throw cstmt5;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        statement.element = BufferStatementFactory.INSTANCE.getRemoveStatement(bufferNumber);
        autoCloseable = conn.prepareCall((String)statement.element);
        throwable = null;
        try {
            cstmt2 = (CallableStatement)autoCloseable;
            boolean bl = false;
            cstmt2.execute();
            this.logger.debug((Function0)new /* Unavailable Anonymous Inner Class!! */);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String clobToString(Clob cl) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        Closeable closeable = new BufferedReader(new InputStreamReader(cl.getAsciiStream()));
        Throwable throwable = null;
        try {
            BufferedReader br = (BufferedReader)closeable;
            boolean bl = false;
            String line = null;
            while (true) {
                String string;
                String it = string = br.readLine();
                boolean bl2 = false;
                line = it;
                if (string == null) break;
                sb.append(line);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

