/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.service;

import flysql.domain.license.models.SqlDataReducer;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.SqlQuery;
import flysql.domain.models.SqlQueryResult;
import flysql.domain.service.AbstractSqlQueryExecutorService;
import flysql.domain.service.AvaloqSqlQueryExecuterService;
import flysql.domain.service.DbExecutor;
import flysql.domain.usecases.AvaloqSqlQueryExecutor;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!render"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lflysql/domain/service/AvaloqSqlQueryExecuterService;", "Lflysql/domain/usecases/AvaloqSqlQueryExecutor;", "Lflysql/domain/service/AbstractSqlQueryExecutorService;", "dbExecutor", "Lflysql/domain/service/DbExecutor;", "sqlDataReducer", "Lflysql/domain/license/models/SqlDataReducer;", "(Lflysql/domain/service/DbExecutor;Lflysql/domain/license/models/SqlDataReducer;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "preSqlAvaloqScript", "", "executeWithPreAvaloqScript", "Lflysql/domain/models/SqlQueryResult;", "sqlQuery", "Lflysql/domain/models/SqlQuery;", "flysql-executor"})
public class AvaloqSqlQueryExecuterService
extends AbstractSqlQueryExecutorService
implements AvaloqSqlQueryExecutor {
    @NotNull
    private final DbExecutor dbExecutor;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String preSqlAvaloqScript;

    public AvaloqSqlQueryExecuterService(@NotNull DbExecutor dbExecutor, @NotNull SqlDataReducer sqlDataReducer) {
        Intrinsics.checkNotNullParameter((Object)dbExecutor, (String)"dbExecutor");
        Intrinsics.checkNotNullParameter((Object)sqlDataReducer, (String)"sqlDataReducer");
        super(sqlDataReducer);
        this.dbExecutor = dbExecutor;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.preSqlAvaloqScript = "begin k.session#.open_session(); end;";
    }

    @NotNull
    public SqlQueryResult executeWithPreAvaloqScript(@NotNull SqlQuery sqlQuery) {
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        DbConnectionConfig dbConnectionConfig = sqlQuery.getDbConnectionConfig();
        return (SqlQueryResult)this.dbExecutor.executeWithConnection(dbConnectionConfig, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(AvaloqSqlQueryExecuterService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getPreSqlAvaloqScript$p(AvaloqSqlQueryExecuterService $this) {
        return $this.preSqlAvaloqScript;
    }
}

