/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.service;

import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.DbType;
import flysql.domain.models.SqlQuery;
import flysql.domain.models.SqlQueryResult;
import flysql.domain.service.CompareServiceExecutionDispatcher;
import flysql.domain.usecases.AvaloqSqlQueryExecutor;
import flysql.domain.usecases.SqlQueryExecutor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lflysql/domain/service/CompareServiceExecutionDispatcher;", "", "avaloqSqlQueryExecutor", "Lflysql/domain/usecases/AvaloqSqlQueryExecutor;", "sqlQueryExecutor", "Lflysql/domain/usecases/SqlQueryExecutor;", "(Lflysql/domain/usecases/AvaloqSqlQueryExecutor;Lflysql/domain/usecases/SqlQueryExecutor;)V", "execute", "Lflysql/domain/models/SqlQueryResult;", "dbConfig", "Lflysql/domain/models/DbConnectionConfig;", "sql", "", "getExecutor", "Lkotlin/Function1;", "Lflysql/domain/models/SqlQuery;", "dbType", "Lflysql/domain/models/DbType;", "flysql-executor"})
public class CompareServiceExecutionDispatcher {
    @NotNull
    private final AvaloqSqlQueryExecutor avaloqSqlQueryExecutor;
    @NotNull
    private final SqlQueryExecutor sqlQueryExecutor;

    public CompareServiceExecutionDispatcher(@NotNull AvaloqSqlQueryExecutor avaloqSqlQueryExecutor, @NotNull SqlQueryExecutor sqlQueryExecutor) {
        Intrinsics.checkNotNullParameter((Object)avaloqSqlQueryExecutor, (String)"avaloqSqlQueryExecutor");
        Intrinsics.checkNotNullParameter((Object)sqlQueryExecutor, (String)"sqlQueryExecutor");
        this.avaloqSqlQueryExecutor = avaloqSqlQueryExecutor;
        this.sqlQueryExecutor = sqlQueryExecutor;
    }

    @NotNull
    public SqlQueryResult execute(@NotNull DbConnectionConfig dbConfig, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return (SqlQueryResult)this.getExecutor(dbConfig.getDbType()).invoke((Object)new SqlQuery(dbConfig, sql));
    }

    private Function1<SqlQuery, SqlQueryResult> getExecutor(DbType dbType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[dbType.ordinal()]) {
            case 1 -> (Function1)new /* Unavailable Anonymous Inner Class!! */;
            case 2 -> (Function1)new /* Unavailable Anonymous Inner Class!! */;
            default -> throw new NoWhenBranchMatchedException();
        };
    }
}

