/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.mashape.unirest.http.HttpResponse;
import java.io.IOException;

public class ClientException
extends Exception {
    static final long serialVersionUID = 0L;
    private final String errorMessage;
    private final int statusCode;

    public ClientException(Throwable t) {
        super(t);
        this.errorMessage = "Client exception";
        this.statusCode = 0;
    }

    public ClientException(HttpResponse<?> resp) {
        String msg = "";
        try {
            msg = new String(resp.getRawBody().readAllBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.errorMessage = msg;
        this.statusCode = resp.getStatus();
    }

    public ClientException(String errorMessage, int statusCode) {
        this.errorMessage = errorMessage;
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        return String.format("ClientException (status=%d): %s", this.statusCode, this.errorMessage);
    }

    public int status() {
        return this.statusCode;
    }

    public String message() {
        return this.errorMessage;
    }
}

