/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Collection;
import com.telenordigital.nbiot.FieldMask;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Collection", generator="Immutables")
@Immutable
public final class ImmutableCollection
implements Collection {
    @Nullable
    private final String id;
    @Nullable
    private final String teamID;
    @Nullable
    private final FieldMask fieldMask;
    @Nullable
    private final Map<String, String> tags;

    private ImmutableCollection(@Nullable String id, @Nullable String teamID, @Nullable FieldMask fieldMask, @Nullable Map<String, String> tags) {
        this.id = id;
        this.teamID = teamID;
        this.fieldMask = fieldMask;
        this.tags = tags;
    }

    @Override
    @JsonProperty(value="collectionId")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="teamId")
    @Nullable
    public String teamID() {
        return this.teamID;
    }

    @Override
    @JsonProperty(value="fieldMask")
    @Nullable
    public FieldMask fieldMask() {
        return this.fieldMask;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    public final ImmutableCollection withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCollection(value, this.teamID, this.fieldMask, this.tags);
    }

    public final ImmutableCollection withTeamID(@Nullable String value) {
        if (Objects.equals(this.teamID, value)) {
            return this;
        }
        return new ImmutableCollection(this.id, value, this.fieldMask, this.tags);
    }

    public final ImmutableCollection withFieldMask(@Nullable FieldMask value) {
        if (this.fieldMask == value) {
            return this;
        }
        return new ImmutableCollection(this.id, this.teamID, value, this.tags);
    }

    public final ImmutableCollection withTags(@Nullable Map<String, ? extends String> entries) {
        if (this.tags == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableCollection.createUnmodifiableMap(true, false, entries);
        return new ImmutableCollection(this.id, this.teamID, this.fieldMask, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollection && this.equalTo((ImmutableCollection)another);
    }

    private boolean equalTo(ImmutableCollection another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.teamID, another.teamID) && Objects.equals(this.fieldMask, another.fieldMask) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.teamID);
        h += (h << 5) + Objects.hashCode(this.fieldMask);
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "Collection{id=" + this.id + ", teamID=" + this.teamID + ", fieldMask=" + this.fieldMask + ", tags=" + this.tags + "}";
    }

    public static ImmutableCollection copyOf(Collection instance) {
        if (instance instanceof ImmutableCollection) {
            return (ImmutableCollection)instance;
        }
        return new Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Collection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String teamID;
        @Nullable
        private FieldMask fieldMask;
        private Map<String, String> tags = null;

        public final Builder from(Collection instance) {
            Map<String, String> tagsValue;
            FieldMask fieldMaskValue;
            String teamIDValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((teamIDValue = instance.teamID()) != null) {
                this.teamID(teamIDValue);
            }
            if ((fieldMaskValue = instance.fieldMask()) != null) {
                this.fieldMask(fieldMaskValue);
            }
            if ((tagsValue = instance.tags()) != null) {
                this.putAllTags(tagsValue);
            }
            return this;
        }

        @JsonProperty(value="collectionId")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="teamId")
        public final Builder teamID(@Nullable String teamID) {
            this.teamID = teamID;
            return this;
        }

        @JsonProperty(value="fieldMask")
        public final Builder fieldMask(@Nullable FieldMask fieldMask) {
            this.fieldMask = fieldMask;
            return this;
        }

        public final Builder putTags(String key, String value) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            this.tags.put(Objects.requireNonNull(key, "tags key"), Objects.requireNonNull(value, "tags value"));
            return this;
        }

        public final Builder putTags(Map.Entry<String, ? extends String> entry) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.tags = null;
                return this;
            }
            this.tags = new LinkedHashMap<String, String>();
            return this.putAllTags(entries);
        }

        public final Builder putAllTags(Map<String, ? extends String> entries) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            }
            return this;
        }

        public ImmutableCollection build() {
            return new ImmutableCollection(this.id, this.teamID, this.fieldMask, this.tags == null ? null : ImmutableCollection.createUnmodifiableMap(false, false, this.tags));
        }
    }
}

