/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Device;
import com.telenordigital.nbiot.OutputDataMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OutputDataMessage", generator="Immutables")
@Immutable
public final class ImmutableOutputDataMessage
implements OutputDataMessage {
    private final Device device;
    private final byte[] payload;
    private final Instant received;

    private ImmutableOutputDataMessage(Device device, byte[] payload, Instant received) {
        this.device = device;
        this.payload = payload;
        this.received = received;
    }

    @Override
    @JsonProperty(value="device")
    public Device device() {
        return this.device;
    }

    @Override
    @JsonProperty(value="payload")
    public byte[] payload() {
        return (byte[])this.payload.clone();
    }

    @Override
    @JsonProperty(value="received")
    public Instant received() {
        return this.received;
    }

    public final ImmutableOutputDataMessage withDevice(Device value) {
        if (this.device == value) {
            return this;
        }
        Device newValue = Objects.requireNonNull(value, "device");
        return new ImmutableOutputDataMessage(newValue, this.payload, this.received);
    }

    public final ImmutableOutputDataMessage withPayload(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableOutputDataMessage(this.device, newValue, this.received);
    }

    public final ImmutableOutputDataMessage withReceived(Instant value) {
        if (this.received == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "received");
        return new ImmutableOutputDataMessage(this.device, this.payload, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOutputDataMessage && this.equalTo((ImmutableOutputDataMessage)another);
    }

    private boolean equalTo(ImmutableOutputDataMessage another) {
        return this.device.equals(another.device) && Arrays.equals(this.payload, another.payload) && this.received.equals(another.received);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.device.hashCode();
        h += (h << 5) + Arrays.hashCode(this.payload);
        h += (h << 5) + this.received.hashCode();
        return h;
    }

    public String toString() {
        return "OutputDataMessage{device=" + this.device + ", payload=" + Arrays.toString(this.payload) + ", received=" + this.received + "}";
    }

    public static ImmutableOutputDataMessage copyOf(OutputDataMessage instance) {
        if (instance instanceof ImmutableOutputDataMessage) {
            return (ImmutableOutputDataMessage)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="OutputDataMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEVICE = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private static final long INIT_BIT_RECEIVED = 4L;
        private long initBits = 7L;
        @Nullable
        private Device device;
        @Nullable
        private byte[] payload;
        @Nullable
        private Instant received;

        public final Builder from(OutputDataMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.device(instance.device());
            this.payload(instance.payload());
            this.received(instance.received());
            return this;
        }

        @JsonProperty(value="device")
        public final Builder device(Device device) {
            this.device = Objects.requireNonNull(device, "device");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="payload")
        public final Builder payload(byte ... payload) {
            this.payload = (byte[])payload.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="received")
        public final Builder received(Instant received) {
            this.received = Objects.requireNonNull(received, "received");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableOutputDataMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOutputDataMessage(this.device, this.payload, this.received);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("device");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("received");
            }
            return "Cannot build OutputDataMessage, some of required attributes are not set " + attributes;
        }
    }
}

