/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.telenordigital.nbiot.ImmutableIFTTTOutput;
import com.telenordigital.nbiot.ImmutableMQTTOutput;
import com.telenordigital.nbiot.ImmutableOutputInternal;
import com.telenordigital.nbiot.ImmutableOutputList;
import com.telenordigital.nbiot.ImmutableUDPOutput;
import com.telenordigital.nbiot.ImmutableWebHookOutput;
import com.telenordigital.nbiot.Output;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableOutputInternal.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
abstract class OutputInternal
implements Output {
    OutputInternal() {
    }

    @Override
    @JsonProperty(value="outputId")
    @Nullable
    public abstract String id();

    @Override
    @JsonProperty(value="collectionId")
    @Nullable
    public abstract String collectionID();

    @JsonProperty(value="type")
    @Nullable
    public abstract String type();

    @JsonProperty(value="config")
    @Nullable
    public abstract Map<String, Object> config();

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public abstract Boolean enabled();

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public abstract Map<String, String> tags();

    protected Output toOutput() {
        switch (this.type()) {
            case "webhook": {
                return new ImmutableWebHookOutput.Builder().id(this.id()).collectionID(this.collectionID()).url(this.str("url")).basicAuthUser(this.str("basicAuthUser")).basicAuthPass(this.str("basicAuthPass")).customHeaderName(this.str("customHeaderName")).customHeaderValue(this.str("customHeaderValue")).enabled(this.enabled()).tags(this.tags()).build();
            }
            case "mqtt": {
                return new ImmutableMQTTOutput.Builder().id(this.id()).collectionID(this.collectionID()).endpoint(this.str("endpoint")).disableCertCheck(this.bool("disableCertCheck")).username(this.str("username")).password(this.str("password")).clientID(this.str("clientID")).topicName(this.str("topicName")).enabled(this.enabled()).tags(this.tags()).build();
            }
            case "ifttt": {
                return new ImmutableIFTTTOutput.Builder().id(this.id()).collectionID(this.collectionID()).key(this.str("key")).eventName(this.str("eventName")).asIsPayload(this.bool("asIsPayload")).enabled(this.enabled()).tags(this.tags()).build();
            }
            case "udp": {
                return new ImmutableUDPOutput.Builder().id(this.id()).collectionID(this.collectionID()).host(this.str("host")).port(this.integer("port")).enabled(this.enabled()).tags(this.tags()).build();
            }
        }
        return this;
    }

    private String str(String key) {
        Object o = this.config().get(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private Boolean bool(String key) {
        Object o = this.config().get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    private Integer integer(String key) {
        Object o = this.config().get(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    @JsonDeserialize(builder=ImmutableOutputList.Builder.class)
    @Value.Immutable
    @Value.Style(builder="new")
    static interface OutputList {
        @JsonProperty(value="outputs")
        @Nullable
        public OutputInternal[] outputs();
    }
}

