package fi.evolver.script;

import java.util.List;

import org.junit.jupiter.api.Test;

import fi.evolver.script.Shell.Command;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;


public class ShellTest {

	@Test
	public void simpleUserCommand() {
		assertEquals("foo", Shell.user("echo", "-n", "foo"));
		assertEquals("foo\n", Shell.user(List.of("echo", "foo")));
		assertEqualTextResults(new Shell.Result(0, null, "foo\n", ""), Command.user("echo", "foo").run());
		assertEqualTextResults(new Shell.Result(0, null, "foo", ""), Command.user(List.of("echo", "-n", "foo")).run());
	}


	@Test
	public void standardInput() {
		assertEqualTextResults(
				new Shell.Result(0, null, "foo", ""),
				Command.user("cat").stdin("foo").run());
	}


	@Test
	public void failOnError() {
	    assertThrows(RuntimeException.class, () -> {
	    	Shell.user("-foo-");
	    });
	}


	@Test
	public void noNotFailOnError() {
		assertEqualTextResults(
				new Shell.Result(2, null, "", "ls: cannot access '/foo': No such file or directory\n"),
				Command.user("ls", "/foo").failOnError(false).run());
	}

	private static void assertEqualTextResults(Shell.Result expected, Shell.Result actual) {
		assertEquals(expected.exitValue(), actual.exitValue());
		assertEquals(expected.stdout(), actual.stdout());
		assertEquals(expected.stderr(), actual.stderr());
	}

}
