/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.sql;

import io.bitsensor.lib.entity.proto.Invocation;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.BitSensorDI;
import io.bitsensor.plugins.java.sql.handler.SQLStatementHandlerManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJdbcInterceptor
extends AbstractCreateStatementInterceptor {
    private static final Map<String, Constructor<?>> CONSTRUCTORS = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJdbcInterceptor.class);
    private static final List<Invocation.SQLInvocation.Query> BATCH_QUERIES = new ArrayList<Invocation.SQLInvocation.Query>();
    private SQLStatementHandlerManager sqlStatementHandlerManager = (SQLStatementHandlerManager)BitSensorDI.getBean(SQLStatementHandlerManager.class);

    private Constructor<?> getConstructor(Class<?> clazz) throws NoSuchMethodException {
        if (!CONSTRUCTORS.containsKey(clazz.getName())) {
            Class<?> proxyClass = Proxy.getProxyClass(BaseJdbcInterceptor.class.getClassLoader(), clazz);
            CONSTRUCTORS.put(clazz.getName(), proxyClass.getConstructor(InvocationHandler.class));
        }
        return CONSTRUCTORS.get(clazz.getName());
    }

    public Object createStatement(Object proxy, Method method, Object[] args, Object statement, long time) {
        try {
            Constructor<?> constructor;
            String name = method.getName();
            String sql = null;
            Invocation.SQLInvocation.Builder sqlInv = this.getSQLInvocationBuilder(statement);
            if (this.compare("createStatement", name)) {
                constructor = this.getConstructor(Statement.class);
            } else if (this.compare("prepareStatement", name)) {
                constructor = this.getConstructor(PreparedStatement.class);
                sql = (String)args[0];
                sqlInv.setPrepareStatement(sql);
            } else if (this.compare("prepareCall", name)) {
                constructor = this.getConstructor(CallableStatement.class);
                sql = (String)args[0];
                sqlInv.setPrepareCall(sql);
            } else {
                return statement;
            }
            return constructor.newInstance(new StatementProxy(statement, sql, sqlInv));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            LOGGER.warn("Unable to create statement proxy for BitSensor.", (Throwable)e);
            return statement;
        }
    }

    private Invocation.SQLInvocation.Builder getSQLInvocationBuilder(Object statement) throws SQLException {
        Statement statement0 = (Statement)statement;
        Connection connection = statement0.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        Invocation.SQLInvocation.Builder sqlInv = Invocation.SQLInvocation.newBuilder();
        sqlInv.putEndpoint("url", metaData.getURL());
        sqlInv.putEndpoint("catalog", connection.getCatalog());
        sqlInv.putEndpoint("user", metaData.getUserName());
        sqlInv.putEndpoint("driver_version", metaData.getDriverVersion());
        sqlInv.putEndpoint("database_type", metaData.getDatabaseProductName());
        sqlInv.putEndpoint("database_version", metaData.getDatabaseProductVersion());
        return sqlInv;
    }

    public void closeInvoked() {
        BATCH_QUERIES.clear();
    }

    protected abstract String queryFormat(String var1);

    private class StatementProxy
    implements InvocationHandler {
        private boolean closed = false;
        private Object delegate;
        private String query;
        private Invocation.SQLInvocation.Builder builder;

        StatementProxy(Object parent, String query, Invocation.SQLInvocation.Builder builder) {
            this.delegate = parent;
            this.query = query;
            this.builder = builder;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            boolean close = BaseJdbcInterceptor.this.compare("close", method);
            if (close && this.closed) {
                return null;
            }
            if (BaseJdbcInterceptor.this.compare("isClosed", method)) {
                return this.closed;
            }
            if (this.closed) {
                throw new SQLException("Statement closed.");
            }
            boolean process = BaseJdbcInterceptor.this.isExecute(method, false);
            long start = 0L;
            if (BaseJdbcInterceptor.this.compare("addBatch", method)) {
                BATCH_QUERIES.add(Invocation.SQLInvocation.Query.newBuilder().setQuery(BaseJdbcInterceptor.this.queryFormat(this.delegate.toString())).build());
            }
            if (process) {
                if (this.query == null && args.length == 1) {
                    this.builder.addQueries(Invocation.SQLInvocation.Query.newBuilder().setQuery(BaseJdbcInterceptor.this.queryFormat(String.valueOf(args[0]))));
                } else if (BaseJdbcInterceptor.this.compare("executeBatch", method)) {
                    this.builder.addAllQueries((Iterable)BATCH_QUERIES);
                    BATCH_QUERIES.clear();
                } else {
                    this.builder.addQueries(Invocation.SQLInvocation.Query.newBuilder().setQuery(BaseJdbcInterceptor.this.queryFormat(this.delegate.toString())));
                }
                start = System.currentTimeMillis();
                this.builder.putEndpoint("start_time", String.valueOf(start)).putEndpoint("successful", String.valueOf(false));
                BitSensor.apply(b -> BaseJdbcInterceptor.this.sqlStatementHandlerManager.preHandle((Statement)this.delegate, this.builder));
            }
            try {
                result = method.invoke(this.delegate, args);
            }
            catch (Throwable t) {
                Throwable throwable = t instanceof InvocationTargetException && t.getCause() != null ? t.getCause() : t;
                BitSensor.apply(b -> BitSensor.addThrowable((Throwable)throwable));
                throw throwable;
            }
            if (process) {
                long delta = System.currentTimeMillis() - start;
                this.builder.putEndpoint("successful", String.valueOf(true)).putEndpoint("result", result instanceof int[] ? Arrays.toString((int[])result) : String.valueOf(result)).putEndpoint("execution_time", String.valueOf(delta));
                BitSensor.apply(b -> BaseJdbcInterceptor.this.sqlStatementHandlerManager.postHandle((Statement)this.delegate, this.builder));
            }
            if (close) {
                this.closed = true;
                this.delegate = null;
            }
            return result;
        }
    }
}

