/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events;

import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsoleteEventCleaner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(ObsoleteEventCleaner.class);

    @Override
    public void scan(Scan data) {
        if (data.getPublishedEvents() == null) {
            return;
        }
        Set<Event> events = data.getPublishedEvents();
        Set<Event> uniqueEvents = this.removeObsoleteAdHocEvents(events);
        data.replacePublishedEvents(uniqueEvents);
    }

    private Set<Event> removeObsoleteAdHocEvents(Set<Event> events) {
        HashMap<String, Event> eventMap = new HashMap<String, Event>();
        ArrayList<Event> eventsWithoutDisplayName = new ArrayList<Event>();
        for (Event event : events) {
            if (event.getDisplayName() == null) {
                eventsWithoutDisplayName.add(event);
                continue;
            }
            if (eventMap.containsKey(event.getDisplayName())) {
                Event existingEventForName = (Event)eventMap.get(event.getDisplayName());
                if (existingEventForName.isAdhocCreatedFromPayload()) {
                    logger.trace("Making duplicate published event " + event.getDisplayName() + " unique");
                    eventMap.put(event.getDisplayName(), event);
                    continue;
                }
                logger.debug("Ignore duplicate published event " + event.getDisplayName());
                continue;
            }
            eventMap.put(event.getDisplayName(), event);
        }
        HashSet<Event> uniqueEvents = new HashSet<Event>(eventMap.values());
        uniqueEvents.addAll(eventsWithoutDisplayName);
        return uniqueEvents;
    }
}

