/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.contextmap.core.reflection.ScannedJsonNodeMerger;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageEntity;
import io.contextmap.spring.runtime.scanner.storage.mongodb.DocumentToJsonConverter;
import io.contextmap.spring.runtime.scanner.storage.mongodb.MongoTemplateMetadataScanner;
import java.util.ArrayList;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.publisher.Flux;

public class ReactiveMongoTemplateMetadataScanner {
    private static final Logger logger = LoggerFactory.getLogger(ReactiveMongoTemplateMetadataScanner.class);

    public static void enrichReactiveMongoWithMetadata(Storage storage, ReactiveMongoTemplate mongoTemplate) {
        ArrayList<StorageEntity> entities = new ArrayList<StorageEntity>();
        storage.setEntities(entities);
        try {
            mongoTemplate.execute(MongoDatabase::listCollectionNames).map(collectionName -> {
                if (entities.size() < 100) {
                    logger.debug("Found collection " + collectionName);
                    StorageEntity entity = MongoTemplateMetadataScanner.createCollectionEntity(collectionName);
                    entities.add(entity);
                    ScannedJsonNode analysis = ReactiveMongoTemplateMetadataScanner.analyzeSchema(collectionName, mongoTemplate);
                    entity.setSchemaAnalysis(analysis);
                }
                return collectionName;
            }).blockLast();
        }
        catch (Exception e) {
            logger.debug("Error: " + e.getMessage());
        }
    }

    private static ScannedJsonNode analyzeSchema(String collectionName, ReactiveMongoTemplate mongoTemplate) {
        ScannedJsonNodeMerger merger = new ScannedJsonNodeMerger();
        mongoTemplate.getCollection(collectionName).flatMapMany(collection -> {
            FindPublisher results = collection.find();
            results.limit(100);
            return Flux.from((Publisher)results);
        }).map(document -> {
            ScannedJsonNode scannedJsonNode = DocumentToJsonConverter.toScannedJsonNode(document);
            merger.merge(scannedJsonNode);
            return document;
        }).blockLast();
        return merger.getMergeResult();
    }
}

