/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.service;

import io.queryanalyzer.example.dto.UserDTO;
import io.queryanalyzer.example.model.Order;
import io.queryanalyzer.example.model.User;
import io.queryanalyzer.example.repository.OrderRepository;
import io.queryanalyzer.example.repository.UserRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService {
    private final UserRepository userRepository;
    private final OrderRepository orderRepository;

    public UserService(UserRepository userRepository, OrderRepository orderRepository) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
    }

    @Transactional(readOnly=true)
    public List<UserDTO> getAllUsersWithOrdersBad() {
        List users = this.userRepository.findAll();
        return users.stream().map(user -> {
            List<String> products = user.getOrders().stream().map(Order::getProductName).collect(Collectors.toList());
            return new UserDTO(user.getId(), user.getName(), user.getEmail(), user.getOrders().size(), products);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Map<Long, Integer> getUserOrderCountsBad() {
        List users = this.userRepository.findAll();
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (User user : users) {
            List<Order> orders = this.orderRepository.findByUserId(user.getId());
            result.put(user.getId(), orders.size());
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> getFullReportBad() {
        List users = this.userRepository.findAll();
        ArrayList<Map<String, Object>> report = new ArrayList<Map<String, Object>>();
        for (User user : users) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("userId", user.getId());
            row.put("userName", user.getName());
            List<Order> orders = user.getOrders();
            row.put("orderCount", orders.size());
            double totalAmount = 0.0;
            ArrayList<String> products = new ArrayList<String>();
            for (Order order : orders) {
                totalAmount += order.getAmount().doubleValue();
                products.add(order.getProductName());
            }
            row.put("totalAmount", totalAmount);
            row.put("products", products);
            report.add(row);
        }
        return report;
    }

    @Transactional(readOnly=true)
    public List<UserDTO> getAllUsersWithOrdersGood() {
        List<User> users = this.userRepository.findAllWithOrders();
        return users.stream().map(user -> {
            List<String> products = user.getOrders().stream().map(Order::getProductName).collect(Collectors.toList());
            return new UserDTO(user.getId(), user.getName(), user.getEmail(), user.getOrders().size(), products);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Map<Long, Integer> getUserOrderCountsGood() {
        List users = this.userRepository.findAll();
        List<Long> userIds = users.stream().map(User::getId).collect(Collectors.toList());
        List<Order> allOrders = this.orderRepository.findByUserIdIn(userIds);
        Map<Long, List<Order>> ordersByUser = allOrders.stream().collect(Collectors.groupingBy(o -> o.getUser().getId()));
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (User user : users) {
            List userOrders = ordersByUser.getOrDefault(user.getId(), List.of());
            result.put(user.getId(), userOrders.size());
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> getFullReportGood() {
        List<User> users = this.userRepository.findAllWithOrders();
        ArrayList<Map<String, Object>> report = new ArrayList<Map<String, Object>>();
        for (User user : users) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("userId", user.getId());
            row.put("userName", user.getName());
            List<Order> orders = user.getOrders();
            row.put("orderCount", orders.size());
            double totalAmount = orders.stream().mapToDouble(o -> o.getAmount().doubleValue()).sum();
            List products = orders.stream().map(Order::getProductName).collect(Collectors.toList());
            row.put("totalAmount", totalAmount);
            row.put("products", products);
            report.add(row);
        }
        return report;
    }

    @Transactional(readOnly=true)
    public User getUserById(Long id) {
        return this.userRepository.findById(id).orElse(null);
    }

    public long countUsers() {
        return this.userRepository.count();
    }
}

