/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import io.queryanalyzer.example.model.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name="orders")
public class Order {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false)
    private String productName;
    @Column(nullable=false, precision=10, scale=2)
    private BigDecimal amount;
    @Column(nullable=false)
    private LocalDateTime orderDate;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="user_id", nullable=false)
    @JsonBackReference
    private User user;

    public Order(String productName, BigDecimal amount, User user) {
        this.productName = productName;
        this.amount = amount;
        this.orderDate = LocalDateTime.now();
        this.user = user;
    }

    public Long getId() {
        return this.id;
    }

    public String getProductName() {
        return this.productName;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public LocalDateTime getOrderDate() {
        return this.orderDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setOrderDate(LocalDateTime orderDate) {
        this.orderDate = orderDate;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Order() {
    }
}

