/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenters;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.HelpCenter;
import com.intercom.api.resources.helpcenters.collections.CollectionsClient;
import com.intercom.api.resources.helpcenters.requests.FindHelpCenterRequest;
import com.intercom.api.resources.helpcenters.requests.ListHelpCentersRequest;
import java.util.function.Supplier;

public class HelpCentersClient {
    protected final ClientOptions clientOptions;

    private final RawHelpCentersClient rawClient;

    protected final Supplier<CollectionsClient> collectionsClient;

    public HelpCentersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawHelpCentersClient(clientOptions);
        this.collectionsClient = Suppliers.memoize(() -> new CollectionsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawHelpCentersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public HelpCenter find(FindHelpCenterRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public HelpCenter find(FindHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public SyncPagingIterable<HelpCenter> list() {
        return this.rawClient.list().body();
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public SyncPagingIterable<HelpCenter> list(ListHelpCentersRequest request) {
        return this.rawClient.list(request).body();
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public SyncPagingIterable<HelpCenter> list(ListHelpCentersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CollectionsClient collections() {
        return this.collectionsClient.get();
    }
}
