/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.teams.requests.RetrieveTeamRequest;
import com.intercom.api.resources.unstable.teams.types.Team;
import com.intercom.api.resources.unstable.types.TeamList;

public class TeamsClient {
    protected final ClientOptions clientOptions;

    private final RawTeamsClient rawClient;

    public TeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTeamsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * This will return a list of team objects for the App.
     */
    public TeamList listTeams() {
        return this.rawClient.listTeams().body();
    }

    /**
     * This will return a list of team objects for the App.
     */
    public TeamList listTeams(RequestOptions requestOptions) {
        return this.rawClient.listTeams(requestOptions).body();
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public Team retrieveTeam(RetrieveTeamRequest request) {
        return this.rawClient.retrieveTeam(request).body();
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public Team retrieveTeam(RetrieveTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveTeam(request, requestOptions).body();
    }
}
