/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = WhatsappMessageStatusList.Builder.class)
public final class WhatsappMessageStatusList {
    private final String rulesetId;

    private final Pages pages;

    private final int totalCount;

    private final List<EventsItem> events;

    private final Map<String, Object> additionalProperties;

    private WhatsappMessageStatusList(
            String rulesetId,
            Pages pages,
            int totalCount,
            List<EventsItem> events,
            Map<String, Object> additionalProperties) {
        this.rulesetId = rulesetId;
        this.pages = pages;
        this.totalCount = totalCount;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return The provided ruleset ID
     */
    @JsonProperty("ruleset_id")
    public String getRulesetId() {
        return rulesetId;
    }

    @JsonProperty("pages")
    public Pages getPages() {
        return pages;
    }

    /**
     * @return Total number of events
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @JsonProperty("events")
    public List<EventsItem> getEvents() {
        return events;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WhatsappMessageStatusList && equalTo((WhatsappMessageStatusList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WhatsappMessageStatusList other) {
        return rulesetId.equals(other.rulesetId)
                && pages.equals(other.pages)
                && totalCount == other.totalCount
                && events.equals(other.events);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rulesetId, this.pages, this.totalCount, this.events);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RulesetIdStage builder() {
        return new Builder();
    }

    public interface RulesetIdStage {
        /**
         * <p>The provided ruleset ID</p>
         */
        PagesStage rulesetId(@NotNull String rulesetId);

        Builder from(WhatsappMessageStatusList other);
    }

    public interface PagesStage {
        TotalCountStage pages(@NotNull Pages pages);
    }

    public interface TotalCountStage {
        /**
         * <p>Total number of events</p>
         */
        _FinalStage totalCount(int totalCount);
    }

    public interface _FinalStage {
        WhatsappMessageStatusList build();

        _FinalStage events(List<EventsItem> events);

        _FinalStage addEvents(EventsItem events);

        _FinalStage addAllEvents(List<EventsItem> events);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RulesetIdStage, PagesStage, TotalCountStage, _FinalStage {
        private String rulesetId;

        private Pages pages;

        private int totalCount;

        private List<EventsItem> events = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(WhatsappMessageStatusList other) {
            rulesetId(other.getRulesetId());
            pages(other.getPages());
            totalCount(other.getTotalCount());
            events(other.getEvents());
            return this;
        }

        /**
         * <p>The provided ruleset ID</p>
         * <p>The provided ruleset ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ruleset_id")
        public PagesStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("pages")
        public TotalCountStage pages(@NotNull Pages pages) {
            this.pages = Objects.requireNonNull(pages, "pages must not be null");
            return this;
        }

        /**
         * <p>Total number of events</p>
         * <p>Total number of events</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllEvents(List<EventsItem> events) {
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addEvents(EventsItem events) {
            this.events.add(events);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "events", nulls = Nulls.SKIP)
        public _FinalStage events(List<EventsItem> events) {
            this.events.clear();
            if (events != null) {
                this.events.addAll(events);
            }
            return this;
        }

        @java.lang.Override
        public WhatsappMessageStatusList build() {
            return new WhatsappMessageStatusList(rulesetId, pages, totalCount, events, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Pages.Builder.class)
    public static final class Pages {
        private final int perPage;

        private final int totalPages;

        private final Optional<Next> next;

        private final Map<String, Object> additionalProperties;

        private Pages(int perPage, int totalPages, Optional<Next> next, Map<String, Object> additionalProperties) {
            this.perPage = perPage;
            this.totalPages = totalPages;
            this.next = next;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty("type")
        public String getType() {
            return "pages";
        }

        /**
         * @return Number of results per page
         */
        @JsonProperty("per_page")
        public int getPerPage() {
            return perPage;
        }

        /**
         * @return Total number of pages
         */
        @JsonProperty("total_pages")
        public int getTotalPages() {
            return totalPages;
        }

        /**
         * @return Information for fetching next page (null if no more pages)
         */
        @JsonProperty("next")
        public Optional<Next> getNext() {
            return next;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Pages && equalTo((Pages) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return perPage == other.perPage && totalPages == other.totalPages && next.equals(other.next);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.perPage, this.totalPages, this.next);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static PerPageStage builder() {
            return new Builder();
        }

        public interface PerPageStage {
            /**
             * <p>Number of results per page</p>
             */
            TotalPagesStage perPage(int perPage);

            Builder from(Pages other);
        }

        public interface TotalPagesStage {
            /**
             * <p>Total number of pages</p>
             */
            _FinalStage totalPages(int totalPages);
        }

        public interface _FinalStage {
            Pages build();

            /**
             * <p>Information for fetching next page (null if no more pages)</p>
             */
            _FinalStage next(Optional<Next> next);

            _FinalStage next(Next next);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements PerPageStage, TotalPagesStage, _FinalStage {
            private int perPage;

            private int totalPages;

            private Optional<Next> next = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Pages other) {
                perPage(other.getPerPage());
                totalPages(other.getTotalPages());
                next(other.getNext());
                return this;
            }

            /**
             * <p>Number of results per page</p>
             * <p>Number of results per page</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("per_page")
            public TotalPagesStage perPage(int perPage) {
                this.perPage = perPage;
                return this;
            }

            /**
             * <p>Total number of pages</p>
             * <p>Total number of pages</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("total_pages")
            public _FinalStage totalPages(int totalPages) {
                this.totalPages = totalPages;
                return this;
            }

            /**
             * <p>Information for fetching next page (null if no more pages)</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage next(Next next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            /**
             * <p>Information for fetching next page (null if no more pages)</p>
             */
            @java.lang.Override
            @JsonSetter(value = "next", nulls = Nulls.SKIP)
            public _FinalStage next(Optional<Next> next) {
                this.next = next;
                return this;
            }

            @java.lang.Override
            public Pages build() {
                return new Pages(perPage, totalPages, next, additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = Next.Builder.class)
        public static final class Next {
            private final Optional<String> startingAfter;

            private final Map<String, Object> additionalProperties;

            private Next(Optional<String> startingAfter, Map<String, Object> additionalProperties) {
                this.startingAfter = startingAfter;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return Cursor for the next page
             */
            @JsonProperty("starting_after")
            public Optional<String> getStartingAfter() {
                return startingAfter;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof Next && equalTo((Next) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Next other) {
                return startingAfter.equals(other.startingAfter);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.startingAfter);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder {
                private Optional<String> startingAfter = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                public Builder from(Next other) {
                    startingAfter(other.getStartingAfter());
                    return this;
                }

                /**
                 * <p>Cursor for the next page</p>
                 */
                @JsonSetter(value = "starting_after", nulls = Nulls.SKIP)
                public Builder startingAfter(Optional<String> startingAfter) {
                    this.startingAfter = startingAfter;
                    return this;
                }

                public Builder startingAfter(String startingAfter) {
                    this.startingAfter = Optional.ofNullable(startingAfter);
                    return this;
                }

                public Next build() {
                    return new Next(startingAfter, additionalProperties);
                }
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = EventsItem.Builder.class)
    public static final class EventsItem {
        private final String id;

        private final String conversationId;

        private final Status status;

        private final int createdAt;

        private final int updatedAt;

        private final String whatsappMessageId;

        private final Optional<String> templateName;

        private final Map<String, Object> additionalProperties;

        private EventsItem(
                String id,
                String conversationId,
                Status status,
                int createdAt,
                int updatedAt,
                String whatsappMessageId,
                Optional<String> templateName,
                Map<String, Object> additionalProperties) {
            this.id = id;
            this.conversationId = conversationId;
            this.status = status;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.whatsappMessageId = whatsappMessageId;
            this.templateName = templateName;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Event ID
         */
        @JsonProperty("id")
        public String getId() {
            return id;
        }

        /**
         * @return ID of the conversation
         */
        @JsonProperty("conversation_id")
        public String getConversationId() {
            return conversationId;
        }

        /**
         * @return Current status of the message
         */
        @JsonProperty("status")
        public Status getStatus() {
            return status;
        }

        /**
         * @return Event type
         */
        @JsonProperty("type")
        public String getType() {
            return "broadcast_outbound";
        }

        /**
         * @return Creation timestamp
         */
        @JsonProperty("created_at")
        public int getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Last update timestamp
         */
        @JsonProperty("updated_at")
        public int getUpdatedAt() {
            return updatedAt;
        }

        /**
         * @return WhatsApp's message identifier
         */
        @JsonProperty("whatsapp_message_id")
        public String getWhatsappMessageId() {
            return whatsappMessageId;
        }

        /**
         * @return Name of the WhatsApp template used
         */
        @JsonProperty("template_name")
        public Optional<String> getTemplateName() {
            return templateName;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof EventsItem && equalTo((EventsItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(EventsItem other) {
            return id.equals(other.id)
                    && conversationId.equals(other.conversationId)
                    && status.equals(other.status)
                    && createdAt == other.createdAt
                    && updatedAt == other.updatedAt
                    && whatsappMessageId.equals(other.whatsappMessageId)
                    && templateName.equals(other.templateName);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.id,
                    this.conversationId,
                    this.status,
                    this.createdAt,
                    this.updatedAt,
                    this.whatsappMessageId,
                    this.templateName);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        public interface IdStage {
            /**
             * <p>Event ID</p>
             */
            ConversationIdStage id(@NotNull String id);

            Builder from(EventsItem other);
        }

        public interface ConversationIdStage {
            /**
             * <p>ID of the conversation</p>
             */
            StatusStage conversationId(@NotNull String conversationId);
        }

        public interface StatusStage {
            /**
             * <p>Current status of the message</p>
             */
            CreatedAtStage status(@NotNull Status status);
        }

        public interface CreatedAtStage {
            /**
             * <p>Creation timestamp</p>
             */
            UpdatedAtStage createdAt(int createdAt);
        }

        public interface UpdatedAtStage {
            /**
             * <p>Last update timestamp</p>
             */
            WhatsappMessageIdStage updatedAt(int updatedAt);
        }

        public interface WhatsappMessageIdStage {
            /**
             * <p>WhatsApp's message identifier</p>
             */
            _FinalStage whatsappMessageId(@NotNull String whatsappMessageId);
        }

        public interface _FinalStage {
            EventsItem build();

            /**
             * <p>Name of the WhatsApp template used</p>
             */
            _FinalStage templateName(Optional<String> templateName);

            _FinalStage templateName(String templateName);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder
                implements IdStage,
                        ConversationIdStage,
                        StatusStage,
                        CreatedAtStage,
                        UpdatedAtStage,
                        WhatsappMessageIdStage,
                        _FinalStage {
            private String id;

            private String conversationId;

            private Status status;

            private int createdAt;

            private int updatedAt;

            private String whatsappMessageId;

            private Optional<String> templateName = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(EventsItem other) {
                id(other.getId());
                conversationId(other.getConversationId());
                status(other.getStatus());
                createdAt(other.getCreatedAt());
                updatedAt(other.getUpdatedAt());
                whatsappMessageId(other.getWhatsappMessageId());
                templateName(other.getTemplateName());
                return this;
            }

            /**
             * <p>Event ID</p>
             * <p>Event ID</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("id")
            public ConversationIdStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            /**
             * <p>ID of the conversation</p>
             * <p>ID of the conversation</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("conversation_id")
            public StatusStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            /**
             * <p>Current status of the message</p>
             * <p>Current status of the message</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("status")
            public CreatedAtStage status(@NotNull Status status) {
                this.status = Objects.requireNonNull(status, "status must not be null");
                return this;
            }

            /**
             * <p>Creation timestamp</p>
             * <p>Creation timestamp</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("created_at")
            public UpdatedAtStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * <p>Last update timestamp</p>
             * <p>Last update timestamp</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("updated_at")
            public WhatsappMessageIdStage updatedAt(int updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * <p>WhatsApp's message identifier</p>
             * <p>WhatsApp's message identifier</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("whatsapp_message_id")
            public _FinalStage whatsappMessageId(@NotNull String whatsappMessageId) {
                this.whatsappMessageId =
                        Objects.requireNonNull(whatsappMessageId, "whatsappMessageId must not be null");
                return this;
            }

            /**
             * <p>Name of the WhatsApp template used</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage templateName(String templateName) {
                this.templateName = Optional.ofNullable(templateName);
                return this;
            }

            /**
             * <p>Name of the WhatsApp template used</p>
             */
            @java.lang.Override
            @JsonSetter(value = "template_name", nulls = Nulls.SKIP)
            public _FinalStage templateName(Optional<String> templateName) {
                this.templateName = templateName;
                return this;
            }

            @java.lang.Override
            public EventsItem build() {
                return new EventsItem(
                        id,
                        conversationId,
                        status,
                        createdAt,
                        updatedAt,
                        whatsappMessageId,
                        templateName,
                        additionalProperties);
            }
        }

        public static final class Status {
            public static final Status DELIVERED = new Status(Value.DELIVERED, "delivered");

            public static final Status FAILED = new Status(Value.FAILED, "failed");

            public static final Status READ = new Status(Value.READ, "read");

            public static final Status SENT = new Status(Value.SENT, "sent");

            private final Value value;

            private final String string;

            Status(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case DELIVERED:
                        return visitor.visitDelivered();
                    case FAILED:
                        return visitor.visitFailed();
                    case READ:
                        return visitor.visitRead();
                    case SENT:
                        return visitor.visitSent();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Status valueOf(String value) {
                switch (value) {
                    case "delivered":
                        return DELIVERED;
                    case "failed":
                        return FAILED;
                    case "read":
                        return READ;
                    case "sent":
                        return SENT;
                    default:
                        return new Status(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                SENT,

                DELIVERED,

                READ,

                FAILED,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitSent();

                T visitDelivered();

                T visitRead();

                T visitFailed();

                T visitUnknown(String unknownType);
            }
        }
    }
}
