/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.news.types.NewsfeedAssignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NewsItemRequest.Builder.class)
public final class NewsItemRequest {
    private final String title;

    private final Optional<String> body;

    private final int senderId;

    private final Optional<State> state;

    private final Optional<Boolean> deliverSilently;

    private final Optional<List<String>> labels;

    private final Optional<List<Optional<String>>> reactions;

    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;

    private final Map<String, Object> additionalProperties;

    private NewsItemRequest(
            String title,
            Optional<String> body,
            int senderId,
            Optional<State> state,
            Optional<Boolean> deliverSilently,
            Optional<List<String>> labels,
            Optional<List<Optional<String>>> reactions,
            Optional<List<NewsfeedAssignment>> newsfeedAssignments,
            Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.deliverSilently = deliverSilently;
        this.labels = labels;
        this.reactions = reactions;
        this.newsfeedAssignments = newsfeedAssignments;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The title of the news item.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The news item body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the sender of the news item. Must be a teammate on the workspace.
     */
    @JsonProperty("sender_id")
    public int getSenderId() {
        return senderId;
    }

    /**
     * @return News items will not be visible to your users in the assigned newsfeeds until they are set live.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return When set to <code>true</code>, the news item will appear in the messenger newsfeed without showing a notification badge.
     */
    @JsonProperty("deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return deliverSilently;
    }

    /**
     * @return Label names displayed to users to categorize the news item.
     */
    @JsonProperty("labels")
    public Optional<List<String>> getLabels() {
        return labels;
    }

    /**
     * @return Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
     */
    @JsonProperty("reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return reactions;
    }

    /**
     * @return A list of newsfeed_assignments to assign to the specified newsfeed.
     */
    @JsonProperty("newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return newsfeedAssignments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NewsItemRequest && equalTo((NewsItemRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItemRequest other) {
        return title.equals(other.title)
                && body.equals(other.body)
                && senderId == other.senderId
                && state.equals(other.state)
                && deliverSilently.equals(other.deliverSilently)
                && labels.equals(other.labels)
                && reactions.equals(other.reactions)
                && newsfeedAssignments.equals(other.newsfeedAssignments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.title,
                this.body,
                this.senderId,
                this.state,
                this.deliverSilently,
                this.labels,
                this.reactions,
                this.newsfeedAssignments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public interface TitleStage {
        /**
         * <p>The title of the news item.</p>
         */
        SenderIdStage title(@NotNull String title);

        Builder from(NewsItemRequest other);
    }

    public interface SenderIdStage {
        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         */
        _FinalStage senderId(int senderId);
    }

    public interface _FinalStage {
        NewsItemRequest build();

        /**
         * <p>The news item body, which may contain HTML.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         */
        _FinalStage state(Optional<State> state);

        _FinalStage state(State state);

        /**
         * <p>When set to <code>true</code>, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         */
        _FinalStage deliverSilently(Optional<Boolean> deliverSilently);

        _FinalStage deliverSilently(Boolean deliverSilently);

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         */
        _FinalStage labels(Optional<List<String>> labels);

        _FinalStage labels(List<String> labels);

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         */
        _FinalStage reactions(Optional<List<Optional<String>>> reactions);

        _FinalStage reactions(List<Optional<String>> reactions);

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         */
        _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments);

        _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TitleStage, SenderIdStage, _FinalStage {
        private String title;

        private int senderId;

        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();

        private Optional<List<Optional<String>>> reactions = Optional.empty();

        private Optional<List<String>> labels = Optional.empty();

        private Optional<Boolean> deliverSilently = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(NewsItemRequest other) {
            title(other.getTitle());
            body(other.getBody());
            senderId(other.getSenderId());
            state(other.getState());
            deliverSilently(other.getDeliverSilently());
            labels(other.getLabels());
            reactions(other.getReactions());
            newsfeedAssignments(other.getNewsfeedAssignments());
            return this;
        }

        /**
         * <p>The title of the news item.</p>
         * <p>The title of the news item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public SenderIdStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sender_id")
        public _FinalStage senderId(int senderId) {
            this.senderId = senderId;
            return this;
        }

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "newsfeed_assignments", nulls = Nulls.SKIP)
        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "reactions", nulls = Nulls.SKIP)
        public _FinalStage reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage labels(List<String> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "labels", nulls = Nulls.SKIP)
        public _FinalStage labels(Optional<List<String>> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * <p>When set to <code>true</code>, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        /**
         * <p>When set to <code>true</code>, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "deliver_silently", nulls = Nulls.SKIP)
        public _FinalStage deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        /**
         * <p>The news item body, which may contain HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The news item body, which may contain HTML.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public NewsItemRequest build() {
            return new NewsItemRequest(
                    title,
                    body,
                    senderId,
                    state,
                    deliverSilently,
                    labels,
                    reactions,
                    newsfeedAssignments,
                    additionalProperties);
        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIVE:
                    return visitor.visitLive();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live":
                    return LIVE;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            DRAFT,

            LIVE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitDraft();

            T visitLive();

            T visitUnknown(String unknownType);
        }
    }
}
