/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Company {
    private final Optional<String> type;
    private final String id;
    private final String name;
    private final String appId;
    private final Optional<Plan> plan;
    private final String companyId;
    private final Optional<Integer> remoteCreatedAt;
    private final int createdAt;
    private final int updatedAt;
    private final Optional<Integer> lastRequestAt;
    private final Optional<Integer> size;
    private final Optional<String> website;
    private final Optional<String> industry;
    private final int monthlySpend;
    private final int sessionCount;
    private final int userCount;
    private final Optional<Map<String, Object>> customAttributes;
    private final Optional<Tags> tags;
    private final Optional<Segments> segments;
    private final Map<String, Object> additionalProperties;

    private Company(Optional<String> type, String id, String name, String appId, Optional<Plan> plan, String companyId, Optional<Integer> remoteCreatedAt, int createdAt, int updatedAt, Optional<Integer> lastRequestAt, Optional<Integer> size, Optional<String> website, Optional<String> industry, int monthlySpend, int sessionCount, int userCount, Optional<Map<String, Object>> customAttributes, Optional<Tags> tags, Optional<Segments> segments, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.appId = appId;
        this.plan = plan;
        this.companyId = companyId;
        this.remoteCreatedAt = remoteCreatedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastRequestAt = lastRequestAt;
        this.size = size;
        this.website = website;
        this.industry = industry;
        this.monthlySpend = monthlySpend;
        this.sessionCount = sessionCount;
        this.userCount = userCount;
        this.customAttributes = customAttributes;
        this.tags = tags;
        this.segments = segments;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="app_id")
    public String getAppId() {
        return this.appId;
    }

    @JsonProperty(value="plan")
    public Optional<Plan> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="last_request_at")
    public Optional<Integer> getLastRequestAt() {
        return this.lastRequestAt;
    }

    @JsonProperty(value="size")
    public Optional<Integer> getSize() {
        return this.size;
    }

    @JsonProperty(value="website")
    public Optional<String> getWebsite() {
        return this.website;
    }

    @JsonProperty(value="industry")
    public Optional<String> getIndustry() {
        return this.industry;
    }

    @JsonProperty(value="monthly_spend")
    public int getMonthlySpend() {
        return this.monthlySpend;
    }

    @JsonProperty(value="session_count")
    public int getSessionCount() {
        return this.sessionCount;
    }

    @JsonProperty(value="user_count")
    public int getUserCount() {
        return this.userCount;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="tags")
    public Optional<Tags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="segments")
    public Optional<Segments> getSegments() {
        return this.segments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Company && this.equalTo((Company)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Company other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.appId.equals(other.appId) && this.plan.equals(other.plan) && this.companyId.equals(other.companyId) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.lastRequestAt.equals(other.lastRequestAt) && this.size.equals(other.size) && this.website.equals(other.website) && this.industry.equals(other.industry) && this.monthlySpend == other.monthlySpend && this.sessionCount == other.sessionCount && this.userCount == other.userCount && this.customAttributes.equals(other.customAttributes) && this.tags.equals(other.tags) && this.segments.equals(other.segments);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.appId, this.plan, this.companyId, this.remoteCreatedAt, this.createdAt, this.updatedAt, this.lastRequestAt, this.size, this.website, this.industry, this.monthlySpend, this.sessionCount, this.userCount, this.customAttributes, this.tags, this.segments);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Plan {
        private final Optional<String> type;
        private final Optional<String> id;
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Plan(Optional<String> type, Optional<String> id, Optional<String> name, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Plan && this.equalTo((Plan)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Plan other) {
            return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> id = Optional.empty();
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Plan other) {
                this.type(other.getType());
                this.id(other.getId());
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Plan build() {
                return new Plan(this.type, this.id, this.name, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Segments {
        private final Optional<String> type;
        private final Optional<List<Segment>> segments;
        private final Map<String, Object> additionalProperties;

        private Segments(Optional<String> type, Optional<List<Segment>> segments, Map<String, Object> additionalProperties) {
            this.type = type;
            this.segments = segments;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="segments")
        public Optional<List<Segment>> getSegments() {
            return this.segments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Segments && this.equalTo((Segments)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Segments other) {
            return this.type.equals(other.type) && this.segments.equals(other.segments);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.segments);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Segment>> segments = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Segments other) {
                this.type(other.getType());
                this.segments(other.getSegments());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="segments", nulls=Nulls.SKIP)
            public Builder segments(Optional<List<Segment>> segments) {
                this.segments = segments;
                return this;
            }

            public Builder segments(List<Segment> segments) {
                this.segments = Optional.ofNullable(segments);
                return this;
            }

            public Segments build() {
                return new Segments(this.type, this.segments, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Tags {
        private final Optional<String> type;
        private final Optional<List<Object>> tags;
        private final Map<String, Object> additionalProperties;

        private Tags(Optional<String> type, Optional<List<Object>> tags, Map<String, Object> additionalProperties) {
            this.type = type;
            this.tags = tags;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="tags")
        public Optional<List<Object>> getTags() {
            return this.tags;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Tags && this.equalTo((Tags)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Tags other) {
            return this.type.equals(other.type) && this.tags.equals(other.tags);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.tags);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Object>> tags = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Tags other) {
                this.type(other.getType());
                this.tags(other.getTags());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="tags", nulls=Nulls.SKIP)
            public Builder tags(Optional<List<Object>> tags) {
                this.tags = tags;
                return this;
            }

            public Builder tags(List<Object> tags) {
                this.tags = Optional.ofNullable(tags);
                return this;
            }

            public Tags build() {
                return new Tags(this.type, this.tags, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    AppIdStage,
    CompanyIdStage,
    CreatedAtStage,
    UpdatedAtStage,
    MonthlySpendStage,
    SessionCountStage,
    UserCountStage,
    _FinalStage {
        private String id;
        private String name;
        private String appId;
        private String companyId;
        private int createdAt;
        private int updatedAt;
        private int monthlySpend;
        private int sessionCount;
        private int userCount;
        private Optional<Segments> segments = Optional.empty();
        private Optional<Tags> tags = Optional.empty();
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        private Optional<String> industry = Optional.empty();
        private Optional<String> website = Optional.empty();
        private Optional<Integer> size = Optional.empty();
        private Optional<Integer> lastRequestAt = Optional.empty();
        private Optional<Integer> remoteCreatedAt = Optional.empty();
        private Optional<Plan> plan = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Company other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.appId(other.getAppId());
            this.plan(other.getPlan());
            this.companyId(other.getCompanyId());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.lastRequestAt(other.getLastRequestAt());
            this.size(other.getSize());
            this.website(other.getWebsite());
            this.industry(other.getIndustry());
            this.monthlySpend(other.getMonthlySpend());
            this.sessionCount(other.getSessionCount());
            this.userCount(other.getUserCount());
            this.customAttributes(other.getCustomAttributes());
            this.tags(other.getTags());
            this.segments(other.getSegments());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public AppIdStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="app_id")
        public CompanyIdStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public MonthlySpendStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="monthly_spend")
        public SessionCountStage monthlySpend(int monthlySpend) {
            this.monthlySpend = monthlySpend;
            return this;
        }

        @Override
        @JsonSetter(value="session_count")
        public UserCountStage sessionCount(int sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        @Override
        @JsonSetter(value="user_count")
        public _FinalStage userCount(int userCount) {
            this.userCount = userCount;
            return this;
        }

        @Override
        public _FinalStage segments(Segments segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        @Override
        @JsonSetter(value="segments", nulls=Nulls.SKIP)
        public _FinalStage segments(Optional<Segments> segments) {
            this.segments = segments;
            return this;
        }

        @Override
        public _FinalStage tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @Override
        @JsonSetter(value="industry", nulls=Nulls.SKIP)
        public _FinalStage industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public _FinalStage website(String website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        @Override
        @JsonSetter(value="website", nulls=Nulls.SKIP)
        public _FinalStage website(Optional<String> website) {
            this.website = website;
            return this;
        }

        @Override
        public _FinalStage size(Integer size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        @Override
        @JsonSetter(value="size", nulls=Nulls.SKIP)
        public _FinalStage size(Optional<Integer> size) {
            this.size = size;
            return this;
        }

        @Override
        public _FinalStage lastRequestAt(Integer lastRequestAt) {
            this.lastRequestAt = Optional.ofNullable(lastRequestAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_request_at", nulls=Nulls.SKIP)
        public _FinalStage lastRequestAt(Optional<Integer> lastRequestAt) {
            this.lastRequestAt = lastRequestAt;
            return this;
        }

        @Override
        public _FinalStage remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public _FinalStage remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        @Override
        public _FinalStage plan(Plan plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @Override
        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public _FinalStage plan(Optional<Plan> plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public Company build() {
            return new Company(this.type, this.id, this.name, this.appId, this.plan, this.companyId, this.remoteCreatedAt, this.createdAt, this.updatedAt, this.lastRequestAt, this.size, this.website, this.industry, this.monthlySpend, this.sessionCount, this.userCount, this.customAttributes, this.tags, this.segments, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Company build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage plan(Optional<Plan> var1);

        public _FinalStage plan(Plan var1);

        public _FinalStage remoteCreatedAt(Optional<Integer> var1);

        public _FinalStage remoteCreatedAt(Integer var1);

        public _FinalStage lastRequestAt(Optional<Integer> var1);

        public _FinalStage lastRequestAt(Integer var1);

        public _FinalStage size(Optional<Integer> var1);

        public _FinalStage size(Integer var1);

        public _FinalStage website(Optional<String> var1);

        public _FinalStage website(String var1);

        public _FinalStage industry(Optional<String> var1);

        public _FinalStage industry(String var1);

        public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage customAttributes(Map<String, Object> var1);

        public _FinalStage tags(Optional<Tags> var1);

        public _FinalStage tags(Tags var1);

        public _FinalStage segments(Optional<Segments> var1);

        public _FinalStage segments(Segments var1);
    }

    public static interface UserCountStage {
        public _FinalStage userCount(int var1);
    }

    public static interface SessionCountStage {
        public UserCountStage sessionCount(int var1);
    }

    public static interface MonthlySpendStage {
        public SessionCountStage monthlySpend(int var1);
    }

    public static interface UpdatedAtStage {
        public MonthlySpendStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface CompanyIdStage {
        public CreatedAtStage companyId(@NotNull String var1);
    }

    public static interface AppIdStage {
        public CompanyIdStage appId(@NotNull String var1);
    }

    public static interface NameStage {
        public AppIdStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Company var1);
    }
}

