/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.notes.RawNotesClient;
import com.intercom.api.resources.notes.requests.CreateContactNoteRequest;
import com.intercom.api.resources.notes.requests.FindNoteRequest;
import com.intercom.api.resources.notes.requests.ListContactNotesRequest;
import com.intercom.api.resources.notes.types.Note;

public class NotesClient {
    protected final ClientOptions clientOptions;
    private final RawNotesClient rawClient;

    public NotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawNotesClient(clientOptions);
    }

    public RawNotesClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Note> list(ListContactNotesRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Note> list(ListContactNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public Note create(CreateContactNoteRequest request) {
        return this.rawClient.create(request).body();
    }

    public Note create(CreateContactNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Note find(FindNoteRequest request) {
        return this.rawClient.find(request).body();
    }

    public Note find(FindNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }
}

