/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.TicketTypeAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketTypeAttributeList {
    private final Optional<String> type;
    private final Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes;
    private final Map<String, Object> additionalProperties;

    private TicketTypeAttributeList(Optional<String> type, Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes, Map<String, Object> additionalProperties) {
        this.type = type;
        this.ticketTypeAttributes = ticketTypeAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="ticket_type_attributes")
    public Optional<List<Optional<TicketTypeAttribute>>> getTicketTypeAttributes() {
        return this.ticketTypeAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketTypeAttributeList && this.equalTo((TicketTypeAttributeList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttributeList other) {
        return this.type.equals(other.type) && this.ticketTypeAttributes.equals(other.ticketTypeAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ticketTypeAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketTypeAttributeList other) {
            this.type(other.getType());
            this.ticketTypeAttributes(other.getTicketTypeAttributes());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="ticket_type_attributes", nulls=Nulls.SKIP)
        public Builder ticketTypeAttributes(Optional<List<Optional<TicketTypeAttribute>>> ticketTypeAttributes) {
            this.ticketTypeAttributes = ticketTypeAttributes;
            return this;
        }

        public Builder ticketTypeAttributes(List<Optional<TicketTypeAttribute>> ticketTypeAttributes) {
            this.ticketTypeAttributes = Optional.ofNullable(ticketTypeAttributes);
            return this;
        }

        public TicketTypeAttributeList build() {
            return new TicketTypeAttributeList(this.type, this.ticketTypeAttributes, this.additionalProperties);
        }
    }
}

