/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.aicontentsource.types.ContentSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSourcesList {
    private final Optional<String> type;
    private final Optional<Integer> totalCount;
    private final Optional<List<ContentSource>> contentSources;
    private final Map<String, Object> additionalProperties;

    private ContentSourcesList(Optional<String> type, Optional<Integer> totalCount, Optional<List<ContentSource>> contentSources, Map<String, Object> additionalProperties) {
        this.type = type;
        this.totalCount = totalCount;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="content_sources")
    public Optional<List<ContentSource>> getContentSources() {
        return this.contentSources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSourcesList && this.equalTo((ContentSourcesList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSourcesList other) {
        return this.type.equals(other.type) && this.totalCount.equals(other.totalCount) && this.contentSources.equals(other.contentSources);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.totalCount, this.contentSources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<List<ContentSource>> contentSources = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContentSourcesList other) {
            this.type(other.getType());
            this.totalCount(other.getTotalCount());
            this.contentSources(other.getContentSources());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="content_sources", nulls=Nulls.SKIP)
        public Builder contentSources(Optional<List<ContentSource>> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        public Builder contentSources(List<ContentSource> contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        public ContentSourcesList build() {
            return new ContentSourcesList(this.type, this.totalCount, this.contentSources, this.additionalProperties);
        }
    }
}

