/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamPriorityLevel {
    private final Optional<List<Integer>> primaryTeamIds;
    private final Optional<List<Integer>> secondaryTeamIds;
    private final Map<String, Object> additionalProperties;

    private TeamPriorityLevel(Optional<List<Integer>> primaryTeamIds, Optional<List<Integer>> secondaryTeamIds, Map<String, Object> additionalProperties) {
        this.primaryTeamIds = primaryTeamIds;
        this.secondaryTeamIds = secondaryTeamIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="primary_team_ids")
    public Optional<List<Integer>> getPrimaryTeamIds() {
        return this.primaryTeamIds;
    }

    @JsonProperty(value="secondary_team_ids")
    public Optional<List<Integer>> getSecondaryTeamIds() {
        return this.secondaryTeamIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamPriorityLevel && this.equalTo((TeamPriorityLevel)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamPriorityLevel other) {
        return this.primaryTeamIds.equals(other.primaryTeamIds) && this.secondaryTeamIds.equals(other.secondaryTeamIds);
    }

    public int hashCode() {
        return Objects.hash(this.primaryTeamIds, this.secondaryTeamIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Integer>> primaryTeamIds = Optional.empty();
        private Optional<List<Integer>> secondaryTeamIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamPriorityLevel other) {
            this.primaryTeamIds(other.getPrimaryTeamIds());
            this.secondaryTeamIds(other.getSecondaryTeamIds());
            return this;
        }

        @JsonSetter(value="primary_team_ids", nulls=Nulls.SKIP)
        public Builder primaryTeamIds(Optional<List<Integer>> primaryTeamIds) {
            this.primaryTeamIds = primaryTeamIds;
            return this;
        }

        public Builder primaryTeamIds(List<Integer> primaryTeamIds) {
            this.primaryTeamIds = Optional.ofNullable(primaryTeamIds);
            return this;
        }

        @JsonSetter(value="secondary_team_ids", nulls=Nulls.SKIP)
        public Builder secondaryTeamIds(Optional<List<Integer>> secondaryTeamIds) {
            this.secondaryTeamIds = secondaryTeamIds;
            return this;
        }

        public Builder secondaryTeamIds(List<Integer> secondaryTeamIds) {
            this.secondaryTeamIds = Optional.ofNullable(secondaryTeamIds);
            return this;
        }

        public TeamPriorityLevel build() {
            return new TeamPriorityLevel(this.primaryTeamIds, this.secondaryTeamIds, this.additionalProperties);
        }
    }
}

