/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.brands;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.brands.requests.RetrieveBrandRequest;
import com.intercom.api.resources.unstable.brands.types.Brand;
import com.intercom.api.resources.unstable.brands.types.BrandList;
import java.util.concurrent.CompletableFuture;

public class AsyncBrandsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawBrandsClient rawClient;

    public AsyncBrandsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBrandsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawBrandsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves all brands for the workspace, including the default brand.
     * The default brand id always matches the workspace
     */
    public CompletableFuture<BrandList> listBrands() {
        return this.rawClient.listBrands().thenApply(response -> response.body());
    }

    /**
     * Retrieves all brands for the workspace, including the default brand.
     * The default brand id always matches the workspace
     */
    public CompletableFuture<BrandList> listBrands(RequestOptions requestOptions) {
        return this.rawClient.listBrands(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Fetches a specific brand by its unique identifier
     */
    public CompletableFuture<Brand> retrieveBrand(RetrieveBrandRequest request) {
        return this.rawClient.retrieveBrand(request).thenApply(response -> response.body());
    }

    /**
     * Fetches a specific brand by its unique identifier
     */
    public CompletableFuture<Brand> retrieveBrand(RetrieveBrandRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveBrand(request, requestOptions).thenApply(response -> response.body());
    }
}
