/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.notes.requests.CreateNoteRequest;
import com.intercom.api.resources.unstable.notes.requests.ListCompanyNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.ListNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.RetrieveNoteRequest;
import com.intercom.api.resources.unstable.notes.types.Note;
import com.intercom.api.resources.unstable.types.NoteList;

public class NotesClient {
    protected final ClientOptions clientOptions;

    private final RawNotesClient rawClient;

    public NotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawNotesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawNotesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of notes that are associated to a company.
     */
    public NoteList listCompanyNotes(ListCompanyNotesRequest request) {
        return this.rawClient.listCompanyNotes(request).body();
    }

    /**
     * You can fetch a list of notes that are associated to a company.
     */
    public NoteList listCompanyNotes(ListCompanyNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyNotes(request, requestOptions).body();
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public NoteList listNotes(ListNotesRequest request) {
        return this.rawClient.listNotes(request).body();
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public NoteList listNotes(ListNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listNotes(request, requestOptions).body();
    }

    /**
     * You can add a note to a single contact.
     */
    public Note createNote(CreateNoteRequest request) {
        return this.rawClient.createNote(request).body();
    }

    /**
     * You can add a note to a single contact.
     */
    public Note createNote(CreateNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNote(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single note.
     */
    public Note retrieveNote(RetrieveNoteRequest request) {
        return this.rawClient.retrieveNote(request).body();
    }

    /**
     * You can fetch the details of a single note.
     */
    public Note retrieveNote(RetrieveNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNote(request, requestOptions).body();
    }
}
