/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketReply.Builder.class)
public final class TicketReply {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<PartType> partType;

    private final Optional<String> body;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<TicketPartAuthor> author;

    private final Optional<List<PartAttachment>> attachments;

    private final Optional<Boolean> redacted;

    private final Map<String, Object> additionalProperties;

    private TicketReply(
            Optional<String> type,
            Optional<String> id,
            Optional<PartType> partType,
            Optional<String> body,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<TicketPartAuthor> author,
            Optional<List<PartAttachment>> attachments,
            Optional<Boolean> redacted,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.author = author;
        this.attachments = attachments;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket_part
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the part.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Type of the part
     */
    @JsonProperty("part_type")
    public Optional<PartType> getPartType() {
        return partType;
    }

    /**
     * @return The message body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The time the note was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the note was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("author")
    public Optional<TicketPartAuthor> getAuthor() {
        return author;
    }

    /**
     * @return A list of attachments for the part.
     */
    @JsonProperty("attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return attachments;
    }

    /**
     * @return Whether or not the ticket part has been redacted.
     */
    @JsonProperty("redacted")
    public Optional<Boolean> getRedacted() {
        return redacted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketReply && equalTo((TicketReply) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketReply other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && partType.equals(other.partType)
                && body.equals(other.body)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && author.equals(other.author)
                && attachments.equals(other.attachments)
                && redacted.equals(other.redacted);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.partType,
                this.body,
                this.createdAt,
                this.updatedAt,
                this.author,
                this.attachments,
                this.redacted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<PartType> partType = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<TicketPartAuthor> author = Optional.empty();

        private Optional<List<PartAttachment>> attachments = Optional.empty();

        private Optional<Boolean> redacted = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketReply other) {
            type(other.getType());
            id(other.getId());
            partType(other.getPartType());
            body(other.getBody());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            author(other.getAuthor());
            attachments(other.getAttachments());
            redacted(other.getRedacted());
            return this;
        }

        /**
         * <p>Always ticket_part</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id representing the part.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Type of the part</p>
         */
        @JsonSetter(value = "part_type", nulls = Nulls.SKIP)
        public Builder partType(Optional<PartType> partType) {
            this.partType = partType;
            return this;
        }

        public Builder partType(PartType partType) {
            this.partType = Optional.ofNullable(partType);
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The time the note was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The last time the note was updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value = "author", nulls = Nulls.SKIP)
        public Builder author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        public Builder author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         */
        @JsonSetter(value = "attachments", nulls = Nulls.SKIP)
        public Builder attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         */
        @JsonSetter(value = "redacted", nulls = Nulls.SKIP)
        public Builder redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        public Builder redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        public TicketReply build() {
            return new TicketReply(
                    type,
                    id,
                    partType,
                    body,
                    createdAt,
                    updatedAt,
                    author,
                    attachments,
                    redacted,
                    additionalProperties);
        }
    }

    public static final class PartType {
        public static final PartType NOTE = new PartType(Value.NOTE, "note");

        public static final PartType QUICK_REPLY = new PartType(Value.QUICK_REPLY, "quick_reply");

        public static final PartType COMMENT = new PartType(Value.COMMENT, "comment");

        private final Value value;

        private final String string;

        PartType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof PartType && this.string.equals(((PartType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case NOTE:
                    return visitor.visitNote();
                case QUICK_REPLY:
                    return visitor.visitQuickReply();
                case COMMENT:
                    return visitor.visitComment();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static PartType valueOf(String value) {
            switch (value) {
                case "note":
                    return NOTE;
                case "quick_reply":
                    return QUICK_REPLY;
                case "comment":
                    return COMMENT;
                default:
                    return new PartType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            NOTE,

            COMMENT,

            QUICK_REPLY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitNote();

            T visitComment();

            T visitQuickReply();

            T visitUnknown(String unknownType);
        }
    }
}
