/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = EventDetails.Deserializer.class)
public final class EventDetails {
    private final Object value;

    private final int type;

    private EventDetails(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((ConversationAttributeUpdatedByWorkflow) this.value);
        } else if (this.type == 1) {
            return visitor.visit((ConversationAttributeUpdatedByAdmin) this.value);
        } else if (this.type == 2) {
            return visitor.visit((CustomActionStarted) this.value);
        } else if (this.type == 3) {
            return visitor.visit((CustomActionFinished) this.value);
        } else if (this.type == 4) {
            return visitor.visit((OperatorWorkflowEvent) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EventDetails && equalTo((EventDetails) other);
    }

    private boolean equalTo(EventDetails other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static EventDetails of(ConversationAttributeUpdatedByWorkflow value) {
        return new EventDetails(value, 0);
    }

    public static EventDetails of(ConversationAttributeUpdatedByAdmin value) {
        return new EventDetails(value, 1);
    }

    public static EventDetails of(CustomActionStarted value) {
        return new EventDetails(value, 2);
    }

    public static EventDetails of(CustomActionFinished value) {
        return new EventDetails(value, 3);
    }

    public static EventDetails of(OperatorWorkflowEvent value) {
        return new EventDetails(value, 4);
    }

    public interface Visitor<T> {
        T visit(ConversationAttributeUpdatedByWorkflow value);

        T visit(ConversationAttributeUpdatedByAdmin value);

        T visit(CustomActionStarted value);

        T visit(CustomActionFinished value);

        T visit(OperatorWorkflowEvent value);
    }

    static final class Deserializer extends StdDeserializer<EventDetails> {
        Deserializer() {
            super(EventDetails.class);
        }

        @java.lang.Override
        public EventDetails deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ConversationAttributeUpdatedByWorkflow.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ConversationAttributeUpdatedByAdmin.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, CustomActionStarted.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, CustomActionFinished.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, OperatorWorkflowEvent.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
