/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketParts.Builder.class)
public final class TicketParts {
    private final Optional<String> type;

    private final Optional<List<TicketPart>> ticketParts;

    private final Optional<Integer> totalCount;

    private final Map<String, Object> additionalProperties;

    private TicketParts(
            Optional<String> type,
            Optional<List<TicketPart>> ticketParts,
            Optional<Integer> totalCount,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.ticketParts = ticketParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of Ticket Part objects for each ticket. There is a limit of 500 parts.
     */
    @JsonProperty("ticket_parts")
    public Optional<List<TicketPart>> getTicketParts() {
        return ticketParts;
    }

    /**
     * @return
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketParts && equalTo((TicketParts) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketParts other) {
        return type.equals(other.type) && ticketParts.equals(other.ticketParts) && totalCount.equals(other.totalCount);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.ticketParts, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<TicketPart>> ticketParts = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketParts other) {
            type(other.getType());
            ticketParts(other.getTicketParts());
            totalCount(other.getTotalCount());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of Ticket Part objects for each ticket. There is a limit of 500 parts.</p>
         */
        @JsonSetter(value = "ticket_parts", nulls = Nulls.SKIP)
        public Builder ticketParts(Optional<List<TicketPart>> ticketParts) {
            this.ticketParts = ticketParts;
            return this;
        }

        public Builder ticketParts(List<TicketPart> ticketParts) {
            this.ticketParts = Optional.ofNullable(ticketParts);
            return this;
        }

        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        public TicketParts build() {
            return new TicketParts(type, ticketParts, totalCount, additionalProperties);
        }
    }
}
