/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class ProjectSettingsFilesTests {
    @TempDir
    public File temp;

    @Test
    public void iteratorIteratesFiles() throws Exception {
        ProjectSettingsFile file = ProjectSettingsFile.fromFile((File)new File(this.temp, "file.prefs"));
        ProjectSettingsFiles files = new ProjectSettingsFiles(Collections.singleton(file), new ProjectProperties());
        Assertions.assertThat((Iterable)files).containsOnly((Object[])new ProjectSettingsFile[]{file});
    }

    @Test
    public void applyToProjectWithoutFileCopiesToDotSettings() throws Exception {
        ProjectSettingsFile file = this.createPrefsFile();
        ProjectSettingsFiles files = new ProjectSettingsFiles(Collections.singleton(file), new ProjectProperties());
        IProject project = (IProject)Mockito.mock(IProject.class);
        IProgressMonitor monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        IFile projectFile = (IFile)Mockito.mock(IFile.class);
        BDDMockito.given((Object)project.getFile(".settings/foo.prefs")).willReturn((Object)projectFile);
        BDDMockito.given((Object)projectFile.exists()).willReturn((Object)false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ((IFile)BDDMockito.will(invocation -> {
            ((InputStream)invocation.getArgument(0, InputStream.class)).transferTo(out);
            return null;
        }).given((Object)projectFile)).create((InputStream)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IProgressMonitor)ArgumentMatchers.any());
        files.applyToProject(project, monitor);
        ((IFile)Mockito.verify((Object)projectFile)).create((InputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true), (IProgressMonitor)ArgumentMatchers.any());
        Assertions.assertThat((String)out.toString(StandardCharsets.UTF_8)).isEqualTo((Object)"y=z\n");
    }

    @Test
    public void applyToProjectWithFileMergesToDotSettings() throws Exception {
        ProjectSettingsFile file = this.createPrefsFile();
        ProjectSettingsFiles files = new ProjectSettingsFiles(Collections.singleton(file), new ProjectProperties());
        IProject project = (IProject)Mockito.mock(IProject.class);
        IProgressMonitor monitor = (IProgressMonitor)Mockito.mock(IProgressMonitor.class);
        IFile projectFile = (IFile)Mockito.mock(IFile.class);
        BDDMockito.given((Object)project.getFile(".settings/foo.prefs")).willReturn((Object)projectFile);
        BDDMockito.given((Object)projectFile.exists()).willReturn((Object)true);
        BDDMockito.given((Object)projectFile.getContents(true)).willReturn((Object)new ByteArrayInputStream("a=b\n".getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ((IFile)BDDMockito.will(invocation -> {
            ((InputStream)invocation.getArgument(0, InputStream.class)).transferTo(out);
            return null;
        }).given((Object)projectFile)).setContents((InputStream)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (IProgressMonitor)ArgumentMatchers.any());
        files.applyToProject(project, monitor);
        ((IFile)Mockito.verify((Object)projectFile)).setContents((InputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (IProgressMonitor)ArgumentMatchers.eq((Object)monitor));
        Assertions.assertThat((String)out.toString(StandardCharsets.UTF_8)).isEqualTo((Object)"a=b\ny=z\n");
    }

    private ProjectSettingsFile createPrefsFile() throws IOException {
        File prefsFile = new File(this.temp, "foo.prefs");
        Files.copy(new ByteArrayInputStream("y=z\n".getBytes(StandardCharsets.UTF_8)), prefsFile.toPath(), new CopyOption[0]);
        ProjectSettingsFile file = ProjectSettingsFile.fromFile((File)prefsFile);
        return file;
    }
}

