/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;

public class SpringDeprecatedCheck
extends AbstractSpringCheck {
    public int[] getAcceptableTokens() {
        return new int[]{159};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 159) {
            this.visitAnnotation(ast);
        }
    }

    private void visitAnnotation(DetailAST annotation) {
        String text = FullIdent.createFullIdent((DetailAST)annotation.findFirstToken(170).getNextSibling()).getText();
        if ("Deprecated".equals(text) || "java.lang.Deprecated".equals(text)) {
            this.visitDeprecated(annotation);
        }
    }

    private void visitDeprecated(DetailAST deprecated) {
        DetailAST sinceAttribute = this.findSinceAttribute(deprecated);
        if (sinceAttribute == null) {
            this.log(deprecated.getLineNo(), deprecated.getColumnNo(), "deprecated.missingSince", new Object[0]);
        } else {
            DetailAST expr = sinceAttribute.findFirstToken(28);
            DetailAST sinceLiteral = expr.findFirstToken(139);
            if ("\"\"".equals(sinceLiteral.getText())) {
                this.log(deprecated.getLineNo(), deprecated.getColumnNo(), "deprecated.emptySince", new Object[0]);
            }
        }
    }

    private DetailAST findSinceAttribute(DetailAST deprecated) {
        for (DetailAST child = deprecated.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST attributeIdent;
            if (child.getType() != 160 || (attributeIdent = child.findFirstToken(58)) == null || !"since".equals(attributeIdent.getText())) continue;
            return child;
        }
        return null;
    }
}

