/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.formatter.Edit;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.text.edits.TextEdit;

public class StreamsEdit
extends Edit {
    StreamsEdit(String originalContent, TextEdit textEdit) {
        super(originalContent, textEdit);
    }

    public void writeTo(OutputStream outputStream) {
        this.writeTo(outputStream, StandardCharsets.UTF_8);
    }

    public void writeTo(OutputStream outputStream, Charset encoding) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);){
            this.writeTo(writer);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeTo(Appendable appendable) {
        try {
            appendable.append(this.getFormattedContent());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

