/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.jdk8.eclipse;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.IExtendedModifier;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.formatter.Preparator;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.formatter.TokenManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JSpecifyPreparator
implements Preparator {
    private static final Set<String> ANNOTATION_NAMES = new HashSet<String>(Arrays.asList("NonNull", "Nullable", "NullMarked", "NullUnmarked"));

    public void apply(int kind, TokenManager tokenManager, ASTNode astRoot) {
        if ((kind & 8) != 0) {
            Vistor visitor = new Vistor(tokenManager);
            astRoot.accept((ASTVisitor)visitor);
        }
    }

    private static class Vistor
    extends ASTVisitor {
        private final TokenManager tokenManager;

        Vistor(TokenManager tokenManager) {
            this.tokenManager = tokenManager;
        }

        public boolean visit(MethodDeclaration node) {
            Annotation lastAnnotation = this.getLastAnnotation(node.modifiers());
            if (this.isJSpecifyAnnotation(lastAnnotation)) {
                this.tokenManager.lastTokenIn((ASTNode)lastAnnotation, -1).clearLineBreaksAfter();
            }
            return true;
        }

        public void endVisit(SingleVariableDeclaration node) {
            List annotations;
            Annotation lastAnnotation;
            if (node.isVarargs() && this.isJSpecifyAnnotation(lastAnnotation = this.getLastAnnotation(annotations = node.varargsAnnotations()))) {
                this.tokenManager.lastTokenIn((ASTNode)lastAnnotation, -1).spaceAfter();
            }
        }

        private Annotation getLastAnnotation(List<? extends IExtendedModifier> modifiers) {
            Annotation annotation = null;
            for (IExtendedModifier iExtendedModifier : modifiers) {
                if (!iExtendedModifier.isAnnotation()) {
                    return annotation;
                }
                annotation = (Annotation)iExtendedModifier;
            }
            return annotation;
        }

        private boolean isJSpecifyAnnotation(Annotation annotation) {
            return annotation != null && ANNOTATION_NAMES.contains(annotation.getTypeName().toString());
        }
    }
}

