/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.gradle.tasks.CheckFormat;
import io.spring.javaformat.gradle.tasks.Format;
import io.spring.javaformat.gradle.tasks.FormatterTask;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SpringJavaFormatPlugin
implements Plugin<Project> {
    private Project project;

    public void apply(Project project) {
        this.project = project;
        this.addSourceTasks();
    }

    private void addSourceTasks() {
        this.project.getPlugins().withType(JavaBasePlugin.class, plugin -> {
            TaskContainer tasks = this.project.getTasks();
            TaskProvider formatAllProvider = tasks.register("format");
            formatAllProvider.configure(formatAll -> formatAll.setDescription("Apply Spring Java formatting"));
            TaskProvider checkAllProvider = tasks.register("checkFormat");
            checkAllProvider.configure(checkAll -> checkAll.setDescription("Run Spring Java formatting checks"));
            tasks.named("check").configure(check -> check.dependsOn(new Object[]{checkAllProvider}));
            ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(sourceSet -> this.addSourceTasks((SourceSet)sourceSet, (TaskProvider<Task>)checkAllProvider, (TaskProvider<Task>)formatAllProvider));
        });
    }

    private void addSourceTasks(SourceSet sourceSet, TaskProvider<Task> checkAllProvider, TaskProvider<Task> formatAllProvider) {
        TaskProvider<CheckFormat> checkTaskProvider = this.addFormatterTask(sourceSet, CheckFormat.class, "checkFormat", "Run Spring Java formatting checks");
        checkTaskProvider.configure(checkTask -> checkTask.setReportLocation(new File(this.project.getBuildDir(), "reports/format/" + sourceSet.getName() + "/check-format.txt")));
        checkAllProvider.configure(checkAll -> checkAll.dependsOn(new Object[]{checkTaskProvider}));
        TaskProvider<Format> formatTaskProvider = this.addFormatterTask(sourceSet, Format.class, "format", "Apply Spring Java formatting");
        formatTaskProvider.configure(format -> format.conventionMapping("encoding", () -> "UTF-8"));
        formatAllProvider.configure(formatAll -> formatAll.dependsOn(new Object[]{formatTaskProvider}));
    }

    private <T extends FormatterTask> TaskProvider<T> addFormatterTask(SourceSet sourceSet, Class<T> taskType, String name, String desc) {
        String taskName = sourceSet.getTaskName(name, null);
        TaskProvider provider = this.project.getTasks().register(taskName, taskType);
        provider.configure(task -> {
            task.setDescription(desc + " for " + sourceSet.getName());
            task.setSource((FileTree)sourceSet.getAllJava());
            JavaFormatConfig config = JavaFormatConfig.findFrom((File)this.project.getProjectDir());
            task.getIndentationStyle().convention((Object)config.getIndentationStyle());
            task.getJavaBaseline().convention((Object)config.getJavaBaseline());
        });
        return provider;
    }
}

