/*
 * Decompiled with CFR 0.152.
 */
package io.streammachine.driver.domain;

import io.streammachine.driver.domain.StreamMachineEvent;
import io.streammachine.driver.serializer.EventSerializer;
import io.streammachine.driver.serializer.SerializationType;
import io.streammachine.driver.serializer.SerializerProvider;
import io.streammachine.driver.serializer.UnsupportedSerializationTypeException;
import java.io.IOException;

public class StreamMachineEventDTO {
    private final StreamMachineEvent event;
    private final SerializationType serializationType;

    public StreamMachineEventDTO(StreamMachineEvent event, SerializationType serializationType) {
        this.event = event;
        this.serializationType = serializationType;
    }

    public String getSchemaId() {
        return this.event.getStrmSchemaId();
    }

    public String getSerializationTypeHeader() {
        switch (this.serializationType) {
            case JSON: 
            case AVRO_JSON: {
                return "application/json";
            }
            case AVRO_BINARY: {
                return "application/x-avro-binary";
            }
        }
        throw new UnsupportedSerializationTypeException("Unsupported Serialization Type '" + (Object)((Object)this.serializationType) + "'.");
    }

    public byte[] serialize() {
        try {
            Object streamMachineSchema = this.event.getStrmSchema();
            EventSerializer serializer = SerializerProvider.getSerializer(this.getSchemaId(), streamMachineSchema);
            return serializer.serialize(this.event, this.serializationType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StreamMachineEventDTOBuilder builder() {
        return new StreamMachineEventDTOBuilder();
    }

    public StreamMachineEvent getEvent() {
        return this.event;
    }

    public SerializationType getSerializationType() {
        return this.serializationType;
    }

    public static class StreamMachineEventDTOBuilder {
        private StreamMachineEvent event;
        private SerializationType serializationType;

        StreamMachineEventDTOBuilder() {
        }

        public StreamMachineEventDTOBuilder event(StreamMachineEvent event) {
            this.event = event;
            return this;
        }

        public StreamMachineEventDTOBuilder serializationType(SerializationType serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        public StreamMachineEventDTO build() {
            return new StreamMachineEventDTO(this.event, this.serializationType);
        }

        public String toString() {
            return "StreamMachineEventDTO.StreamMachineEventDTOBuilder(event=" + this.event + ", serializationType=" + (Object)((Object)this.serializationType) + ")";
        }
    }
}

