/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Optional;
import net.quedex.api.user.OrderSpec;

public class OrderModificationSpec
implements OrderSpec {
    private final long clientOrderId;
    private final Integer newQuantity;
    private final BigDecimal newLimitPrice;

    public OrderModificationSpec(long clientOrderId, int newQuantity, BigDecimal newLimitPrice) {
        Preconditions.checkArgument((newQuantity > 0 ? 1 : 0) != 0, (String)"newQuantity=%s <= 0", (Object[])new Object[]{newQuantity});
        Preconditions.checkArgument((newLimitPrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"limitPrice=%s <= 0", (Object[])new Object[]{newLimitPrice});
        this.clientOrderId = clientOrderId;
        this.newQuantity = newQuantity;
        this.newLimitPrice = newLimitPrice;
    }

    public OrderModificationSpec(long clientOrderId, int newQuantity) {
        Preconditions.checkArgument((newQuantity > 0 ? 1 : 0) != 0, (String)"newQuantity=%s <= 0", (Object[])new Object[]{newQuantity});
        this.clientOrderId = clientOrderId;
        this.newQuantity = newQuantity;
        this.newLimitPrice = null;
    }

    public OrderModificationSpec(long clientOrderId, BigDecimal newLimitPrice) {
        Preconditions.checkArgument((newLimitPrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"limitPrice=%s <= 0", (Object[])new Object[]{newLimitPrice});
        this.clientOrderId = clientOrderId;
        this.newQuantity = null;
        this.newLimitPrice = newLimitPrice;
    }

    @Override
    @JsonProperty(value="client_order_id")
    public long getClientOrderId() {
        return this.clientOrderId;
    }

    @JsonIgnore
    public Optional<Integer> getNewQuantity() {
        return Optional.ofNullable(this.newQuantity);
    }

    @JsonIgnore
    public Optional<BigDecimal> getNewLimitPrice() {
        return Optional.ofNullable(this.newLimitPrice);
    }

    @JsonProperty(value="new_price")
    private BigDecimal getNewLimitPriceRaw() {
        return this.newLimitPrice;
    }

    @JsonProperty(value="new_quantity")
    private Integer getNewQuantityRaw() {
        return this.newQuantity;
    }

    @JsonProperty(value="type")
    private String getType() {
        return "modify_order";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderModificationSpec that = (OrderModificationSpec)o;
        return this.clientOrderId == that.clientOrderId && Objects.equal((Object)this.newQuantity, (Object)that.newQuantity) && Objects.equal((Object)this.newLimitPrice, (Object)that.newLimitPrice);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.newQuantity, this.newLimitPrice});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("newQuantity", (Object)this.newQuantity).add("newLimitPrice", (Object)this.newLimitPrice).toString();
    }
}

