/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CanonicalXMLEventWriter
implements XMLEventWriter {
    private final XMLStreamWriter swriter;
    private StartElement last;

    public CanonicalXMLEventWriter(XMLStreamWriter swriter) {
        this.swriter = swriter;
    }

    public void flush() throws XMLStreamException {
        this.swriter.flush();
    }

    public void close() throws XMLStreamException {
        this.swriter.close();
    }

    public void add(XMLEvent event) throws XMLStreamException {
        if (event.isEndElement()) {
            this.swriter.writeEndElement();
        } else if (event.isCharacters()) {
            this.swriter.writeCharacters(event.asCharacters().getData());
        } else if (event.isProcessingInstruction()) {
            this.swriter.writeProcessingInstruction(((ProcessingInstruction)event).getData(), ((ProcessingInstruction)event).getTarget());
        } else if (event.isStartElement()) {
            StartElement se = event.asStartElement();
            this.swriter.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
            this.writeAttributes(se);
            this.swriter.writeCharacters("");
        } else {
            System.err.printf("Gah! Missed one <%s>, '%s'\n", event.getClass(), event);
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.swriter.getPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.swriter.setPrefix(prefix, uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.swriter.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.swriter.setNamespaceContext(context);
    }

    public NamespaceContext getNamespaceContext() {
        return this.swriter.getNamespaceContext();
    }

    private void writeAttributes(StartElement se) throws XMLStreamException {
        TreeMap<String, Attribute> atts = new TreeMap<String, Attribute>();
        Iterator<Attribute> i = se.getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            atts.put(this.getName(a), a);
        }
        for (Attribute a : atts.values()) {
            this.swriter.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private String getName(Attribute a) {
        String toReturn;
        QName name = a.getName();
        String string = toReturn = name.getPrefix() == null ? name.getLocalPart() : name.getPrefix() + ":" + name.getLocalPart();
        if (toReturn.startsWith("xml:")) {
            return "_" + toReturn;
        }
        return toReturn;
    }
}

