/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

class IntegerInfo
extends ConstInfo {
    static final int tag = 3;
    int value;

    public IntegerInfo(int i) {
        this.value = i;
    }

    public IntegerInfo(DataInput in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    public int getTag() {
        return 3;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addIntegerInfo(this.value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(3);
        out.writeInt(this.value);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Integer ");
        out.println(this.value);
    }
}

