/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSuperWildcard;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.androidannotations.annotations.EBean;
import org.androidannotations.helper.AnnotationParamExtractor;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;

public class APTCodeModelHelper {
    public JClass typeMirrorToJClass(TypeMirror type, GeneratedClassHolder holder) {
        return this.typeMirrorToJClass(type, holder, Collections.<String, TypeMirror>emptyMap());
    }

    private JClass typeMirrorToJClass(TypeMirror type, GeneratedClassHolder holder, Map<String, TypeMirror> substitute) {
        if (type instanceof DeclaredType) {
            return this.typeMirrorToJClass((DeclaredType)type, holder, substitute);
        }
        if (type instanceof WildcardType) {
            return this.typeMirrorToJClass((WildcardType)type, holder, substitute);
        }
        if (type instanceof ArrayType) {
            return this.typeMirrorToJClass((ArrayType)type, holder, substitute);
        }
        TypeMirror substituted = substitute.get(type.toString());
        if (substituted != null && type != substituted) {
            return this.typeMirrorToJClass(substituted, holder, substitute);
        }
        return holder.refClass(type.toString());
    }

    private JClass typeMirrorToJClass(DeclaredType declaredType, GeneratedClassHolder holder, Map<String, TypeMirror> substitute) {
        String declaredTypeName = declaredType.asElement().toString();
        JClass declaredClass = holder.refClass(declaredTypeName);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        ArrayList<JClass> typeArgumentJClasses = new ArrayList<JClass>();
        for (TypeMirror typeMirror : typeArguments) {
            typeArgumentJClasses.add(this.typeMirrorToJClass(typeMirror, holder, substitute));
        }
        if (typeArgumentJClasses.size() > 0) {
            declaredClass = declaredClass.narrow(typeArgumentJClasses);
        }
        return declaredClass;
    }

    private JClass typeMirrorToJClass(WildcardType wildcardType, GeneratedClassHolder holder, Map<String, TypeMirror> substitute) {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            bound = wildcardType.getSuperBound();
            if (bound == null) {
                return holder.classes().OBJECT.wildcard();
            }
            return new JSuperWildcard(this.typeMirrorToJClass(bound, holder, substitute));
        }
        TypeMirror extendsBound = wildcardType.getExtendsBound();
        if (extendsBound == null) {
            return holder.classes().OBJECT.wildcard();
        }
        return this.typeMirrorToJClass(extendsBound, holder, substitute).wildcard();
    }

    private JClass typeMirrorToJClass(ArrayType arrayType, GeneratedClassHolder holder, Map<String, TypeMirror> substitute) {
        JClass refClass = this.typeMirrorToJClass(arrayType.getComponentType(), holder, substitute);
        return refClass.array();
    }

    private Map<String, TypeMirror> getActualTypes(Types typeUtils, DeclaredType baseClass, TypeMirror annotatedClass) {
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        superTypes.add(annotatedClass);
        while (!superTypes.isEmpty()) {
            TypeMirror x = (TypeMirror)superTypes.remove(0);
            if (typeUtils.isSameType(typeUtils.erasure(x), typeUtils.erasure(baseClass))) {
                DeclaredType type = (DeclaredType)x;
                HashMap<String, TypeMirror> actualTypes = new HashMap<String, TypeMirror>();
                for (int i = 0; i < type.getTypeArguments().size(); ++i) {
                    TypeMirror formalArg;
                    TypeMirror actualArg = type.getTypeArguments().get(i);
                    if (typeUtils.isSameType(actualArg, formalArg = baseClass.getTypeArguments().get(i))) continue;
                    actualTypes.put(formalArg.toString(), actualArg);
                }
                return actualTypes;
            }
            superTypes.addAll(typeUtils.directSupertypes(x));
        }
        return Collections.emptyMap();
    }

    public JClass typeBoundsToJClass(GeneratedClassHolder holder, List<? extends TypeMirror> bounds) {
        return this.typeBoundsToJClass(holder, bounds, Collections.<String, TypeMirror>emptyMap());
    }

    private JClass typeBoundsToJClass(GeneratedClassHolder holder, List<? extends TypeMirror> bounds, Map<String, TypeMirror> actualTypes) {
        if (bounds.isEmpty()) {
            return holder.classes().OBJECT;
        }
        return this.typeMirrorToJClass(bounds.get(0), holder, actualTypes);
    }

    public JMethod overrideAnnotatedMethod(ExecutableElement executableElement, GeneratedClassHolder holder) {
        TypeMirror annotatedClass = holder.getAnnotatedElement().asType();
        DeclaredType baseClass = (DeclaredType)executableElement.getEnclosingElement().asType();
        Types typeUtils = holder.processingEnvironment().getTypeUtils();
        Map<String, TypeMirror> actualTypes = this.getActualTypes(typeUtils, baseClass, annotatedClass);
        LinkedHashMap<String, JClass> methodTypes = new LinkedHashMap<String, JClass>();
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            JClass jClassBounds = this.typeBoundsToJClass(holder, bounds, actualTypes);
            methodTypes.put(typeParameterElement.toString(), jClassBounds);
        }
        actualTypes.keySet().removeAll(methodTypes.keySet());
        JMethod existingMethod = this.findAlreadyGeneratedMethod(executableElement, holder);
        if (existingMethod != null) {
            return existingMethod;
        }
        String string = executableElement.getSimpleName().toString();
        JClass returnType = this.typeMirrorToJClass(executableElement.getReturnType(), holder, actualTypes);
        JMethod method = holder.getGeneratedClass().method(1, returnType, string);
        this.addNonAAAnotations(method, executableElement.getAnnotationMirrors(), holder);
        if (!this.hasAnnotation((JAnnotatable)method, Override.class)) {
            method.annotate(Override.class);
        }
        for (Map.Entry entry : methodTypes.entrySet()) {
            method.generify((String)entry.getKey(), (JClass)entry.getValue());
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            this.addParamToMethod(method, variableElement, 8, holder, actualTypes);
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            JClass thrownType = this.typeMirrorToJClass(typeMirror, holder, actualTypes);
            method._throws(thrownType);
        }
        this.callSuperMethod(method, holder, method.body());
        return method;
    }

    private JMethod findAlreadyGeneratedMethod(ExecutableElement executableElement, GeneratedClassHolder holder) {
        JDefinedClass definedClass = holder.getGeneratedClass();
        String methodName = executableElement.getSimpleName().toString();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        block0: for (JMethod method : definedClass.methods()) {
            if (!method.name().equals(methodName) || method.params().size() != parameters.size()) continue;
            int i = 0;
            for (JVar param : method.params()) {
                String searchedParamType = this.typeMirrorToJClass(parameters.get(i).asType(), holder).name();
                if (!param.type().name().equals(searchedParamType)) continue block0;
                ++i;
            }
            return method;
        }
        return null;
    }

    private void addParamToMethod(JMethod method, VariableElement parameter, int mod, GeneratedClassHolder holder, Map<String, TypeMirror> actualTypes) {
        String parameterName = parameter.getSimpleName().toString();
        JClass parameterClass = this.typeMirrorToJClass(parameter.asType(), holder, actualTypes);
        JVar param = method.param(mod, parameterClass, parameterName);
        this.addNonAAAnotations(param, parameter.getAnnotationMirrors(), holder);
    }

    public void addNonAAAnotations(JAnnotatable annotatable, List<? extends AnnotationMirror> annotationMirrors, GeneratedClassHolder holder) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            JClass annotationClass = this.typeMirrorToJClass(annotationMirror.getAnnotationType(), holder);
            if (annotationClass.fullName().startsWith("org.androidannotations")) continue;
            this.addAnnotation(annotatable, annotationMirror, holder);
        }
    }

    public void addAnnotation(JAnnotatable annotatable, AnnotationMirror annotationMirror, GeneratedClassHolder holder) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> parameters = annotationMirror.getElementValues();
        if (!this.hasAnnotation(annotatable, annotationMirror)) {
            JClass annotation = this.typeMirrorToJClass(annotationMirror.getAnnotationType(), holder);
            JAnnotationUse annotate = annotatable.annotate(annotation);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> param : parameters.entrySet()) {
                param.getValue().accept(new AnnotationParamExtractor(annotate, holder, this), param.getKey().getSimpleName().toString());
            }
        }
    }

    private boolean hasAnnotation(JAnnotatable annotatable, AnnotationMirror annotationMirror) {
        return this.hasAnnotation(annotatable, annotationMirror.getAnnotationType().toString());
    }

    private boolean hasAnnotation(JAnnotatable annotatable, Class<? extends Annotation> annotationClass) {
        return this.hasAnnotation(annotatable, annotationClass.getCanonicalName());
    }

    private boolean hasAnnotation(JAnnotatable annotatable, String annotationFQN) {
        for (JAnnotationUse annotation : annotatable.annotations()) {
            if (!annotation.getAnnotationClass().fullName().equals(annotationFQN)) continue;
            return true;
        }
        return false;
    }

    public JInvocation getSuperCall(GeneratedClassHolder holder, JMethod superMethod) {
        JFieldRef activitySuper = holder.getGeneratedClass().staticRef("super");
        JInvocation superCall = JExpr.invoke((JExpression)activitySuper, superMethod);
        for (JVar param : superMethod.params()) {
            superCall.arg(param);
        }
        return superCall;
    }

    public void callSuperMethod(JMethod superMethod, GeneratedClassHolder holder, JBlock callBlock) {
        JInvocation superCall = this.getSuperCall(holder, superMethod);
        JType returnType = superMethod.type();
        if (returnType.fullName().equals("void")) {
            callBlock.add(superCall);
        } else {
            callBlock._return(superCall);
        }
    }

    public JBlock removeBody(JMethod method) {
        JBlock body = method.body();
        try {
            Field bodyField = JMethod.class.getDeclaredField("body");
            bodyField.setAccessible(true);
            bodyField.set(method, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JBlock clonedBody = new JBlock(false, false);
        this.copy(body, clonedBody);
        return clonedBody;
    }

    public void copy(JBlock body, JBlock newBody) {
        for (Object statement : body.getContents()) {
            if (statement instanceof JVar) {
                JVar var = (JVar)statement;
                try {
                    Field varInitField = JVar.class.getDeclaredField("init");
                    varInitField.setAccessible(true);
                    JExpression varInit = (JExpression)varInitField.get(var);
                    newBody.decl(var.type(), var.name(), varInit);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            newBody.add((JStatement)statement);
        }
    }

    public void replaceSuperCall(JMethod method, JBlock replacement) {
        String superCallStart = "super." + method.name() + "(";
        JBlock oldBody = this.removeBody(method);
        JBlock newBody = method.body();
        for (Object content : oldBody.getContents()) {
            StringWriter writer = new StringWriter();
            JFormatter formatter = new JFormatter(writer);
            JStatement statement = (JStatement)content;
            statement.state(formatter);
            String statementString = writer.getBuffer().toString();
            if (statementString.startsWith(superCallStart)) {
                newBody.add(replacement);
                continue;
            }
            newBody.add(statement);
        }
    }

    public String getIdStringFromIdFieldRef(JFieldRef idRef) {
        try {
            Field nameField = JFieldRef.class.getDeclaredField("name");
            nameField.setAccessible(true);
            String name = (String)nameField.get(idRef);
            if (name != null) {
                return name;
            }
            Field varField = JFieldRef.class.getDeclaredField("var");
            varField.setAccessible(true);
            JVar var = (JVar)varField.get(idRef);
            if (var != null) {
                return var.name();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Unable to extract target name from JFieldRef");
    }

    public JDefinedClass createDelegatingAnonymousRunnableClass(EComponentHolder holder, JBlock previousBody) {
        JCodeModel codeModel = holder.codeModel();
        JDefinedClass anonymousRunnableClass = codeModel.anonymousClass(Runnable.class);
        JMethod runMethod = anonymousRunnableClass.method(1, codeModel.VOID, "run");
        runMethod.annotate(Override.class);
        runMethod.body().add(previousBody);
        return anonymousRunnableClass;
    }

    public List<ExecutableElement> getMethods(TypeElement typeElement) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(ElementFilter.methodsIn(enclosedElements));
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType dt = (DeclaredType)typeMirror;
            methods.addAll(ElementFilter.methodsIn(dt.asElement().getEnclosedElements()));
        }
        return methods;
    }

    public JMethod implementMethod(GeneratedClassHolder holder, List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        return this.implementMethod(holder, methods, methodName, returnType, false, parameterTypes);
    }

    public JMethod implementMethod(GeneratedClassHolder holder, List<ExecutableElement> methods, String methodName, String returnType, boolean finalParams, String ... parameterTypes) {
        ExecutableElement method = this.getMethod(methods, methodName, returnType, parameterTypes);
        JMethod jmethod = null;
        if (method != null) {
            JType jcReturnType = returnType.equals(TypeKind.VOID.toString()) ? holder.codeModel().VOID : holder.refClass(returnType);
            jmethod = holder.getGeneratedClass().method(1, jcReturnType, method.getSimpleName().toString());
            jmethod.annotate(Override.class);
            int paramMods = finalParams ? 8 : 0;
            for (int i = 0; i < method.getParameters().size(); ++i) {
                VariableElement param = method.getParameters().get(i);
                jmethod.param(paramMods, holder.refClass(parameterTypes[i]), param.getSimpleName().toString());
            }
        }
        return jmethod;
    }

    private ExecutableElement getMethod(List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        for (ExecutableElement method : methods) {
            String methodReturnType;
            List<? extends VariableElement> parameters = method.getParameters();
            String string = methodReturnType = method.getReturnType().getKind() == TypeKind.VOID ? TypeKind.VOID.toString() : method.getReturnType().toString();
            if (parameters.size() != parameterTypes.length || !methodReturnType.equals(returnType) || methodName != null && !method.getSimpleName().toString().equals(methodName)) continue;
            boolean validMethod = true;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement param = parameters.get(i);
                if (param.asType().toString().equals(parameterTypes[i])) continue;
                validMethod = false;
                break;
            }
            if (!validMethod) continue;
            return method;
        }
        return null;
    }

    public JInvocation newBeanOrEBean(GeneratedClassHolder holder, DeclaredType beanType, JVar contextVar) {
        if (beanType.asElement().getAnnotation(EBean.class) != null) {
            String typeQualifiedName = beanType.toString();
            JClass injectedClass = holder.refClass(typeQualifiedName + "_");
            return injectedClass.staticInvoke("getInstance_").arg(contextVar);
        }
        return JExpr._new(holder.refClass(beanType.toString()));
    }

    public JExpression litObject(Object o) {
        if (o instanceof Integer) {
            return JExpr.lit((Integer)o);
        }
        if (o instanceof Float) {
            return JExpr.lit(((Float)o).floatValue());
        }
        if (o instanceof Long) {
            return JExpr.lit((Long)o);
        }
        if (o instanceof Boolean) {
            return JExpr.lit((Boolean)o);
        }
        return JExpr.lit((String)o);
    }
}

