/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import org.androidannotations.exception.ProcessingException;

public class ErrorHelper {
    public String getErrorMessage(ProcessingEnvironment processingEnv, ProcessingException e, String aaVersion) {
        String errorMessage = "Unexpected error in AndroidAnnotations " + aaVersion + "!\n" + "You should check if there is already an issue about it on https://github.com/excilys/androidannotations/search?q=" + this.urlEncodedErrorMessage(e) + "&type=Issues\n" + "If none exists, please open a new one with the following content and tell us if you can reproduce it or not. Don't forget to give us as much information as you can (like parts of your code in failure).\n";
        errorMessage = errorMessage + "Java version: " + this.getJavaCompilerVersion() + "\n";
        errorMessage = errorMessage + "Javac processors options: " + this.annotationProcessorOptions(processingEnv) + "\n";
        errorMessage = errorMessage + "Stacktrace: " + this.stackTraceToString(e.getCause());
        Element element = e.getElement();
        if (element != null) {
            errorMessage = errorMessage + "Thrown from: " + this.elementContainer(element) + "\n";
            errorMessage = errorMessage + "Element (" + element.getClass().getSimpleName() + "): " + this.elementFullString(processingEnv, element) + "\n";
        }
        return errorMessage;
    }

    private String elementFullString(ProcessingEnvironment processingEnv, Element element) {
        Elements elementUtils = processingEnv.getElementUtils();
        CharArrayWriter writer = new CharArrayWriter();
        elementUtils.printElements(writer, element);
        return writer.toString();
    }

    private String elementContainer(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        return enclosingElement != null ? enclosingElement.toString() : "";
    }

    private String annotationProcessorOptions(ProcessingEnvironment processingEnv) {
        Map<String, String> options = processingEnv.getOptions();
        Set<Map.Entry<String, String>> optionsEntries = options.entrySet();
        String result = "";
        for (Map.Entry<String, String> optionEntry : optionsEntries) {
            result = result + optionEntry.getKey() + "=" + optionEntry.getValue() + ", ";
        }
        return result.length() > 2 ? result.substring(0, result.length() - 2) : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJavaCompilerVersion() {
        ProcessBuilder pb = new ProcessBuilder("javac", "-version");
        pb.redirectErrorStream(true);
        BufferedReader in = null;
        try {
            Process process = pb.start();
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String buffer = in.readLine();
            process.waitFor();
            String string = buffer;
            return string;
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return "unknown";
    }

    private String urlEncodedErrorMessage(Throwable e) {
        try {
            return URLEncoder.encode(e.getCause().getClass().getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return "";
        }
    }

    private String stackTraceToString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }
}

