/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.util.zip.Checksum;

public class CRC64Checksum
implements Checksum {
    private static final long POLY64 = -2882303761517117440L;
    private static final long[] crcTable = new long[256];
    private long crc;

    @Override
    public void update(int b) {
        long low = this.crc >>> 8;
        long high = crcTable[(int)((this.crc ^ (long)b) & 0xFFL)];
        this.crc = low ^ high;
    }

    @Override
    public void update(byte[] b, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            this.update(b[i]);
        }
    }

    public void update(String s) {
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            this.update(s.charAt(i));
        }
    }

    @Override
    public long getValue() {
        return this.crc;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append(Long.toHexString(this.crc >>> 4));
        builder.append(Long.toHexString(this.crc & 0xFL));
        for (int i = 16 - builder.length(); i > 0; --i) {
            builder.insert(0, '0');
        }
        return builder.toString().toUpperCase();
    }

    @Override
    public void reset() {
        this.crc = 0L;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long part = i;
            for (int j = 0; j < 8; ++j) {
                part = (part & 1L) != 0L ? part >>> 1 ^ 0xD800000000000000L : part >>> 1;
            }
            CRC64Checksum.crcTable[i] = part;
        }
    }
}

