/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.io.util.ClasspathResource;
import org.biojava.nbio.core.sequence.io.util.IOUtils;
import org.biojava.nbio.core.sequence.template.AbstractCompoundSet;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.transcription.Table;

public class IUPACParser {
    public static final String IUPAC_LOCATION = "org/biojava/nbio/core/sequence/iupac.txt";
    private InputStream is;
    private List<IUPACTable> tables;
    private Map<String, IUPACTable> nameLookup;
    private Map<Integer, IUPACTable> idLookup;

    public static IUPACParser getInstance() {
        return IOD.INSTANCE;
    }

    public IUPACParser() {
        this.is = new ClasspathResource(IUPAC_LOCATION, true).getInputStream();
    }

    public IUPACParser(InputStream is) {
        this.is = is;
    }

    public List<IUPACTable> getTables() {
        if (this.tables == null) {
            this.tables = this.parseTables();
        }
        return this.tables;
    }

    public IUPACTable getTable(String name) {
        this.populateLookups();
        return this.nameLookup.get(name);
    }

    public IUPACTable getTable(Integer id) {
        this.populateLookups();
        return this.idLookup.get(id);
    }

    private void populateLookups() {
        if (this.nameLookup == null) {
            this.nameLookup = new HashMap<String, IUPACTable>();
            this.idLookup = new HashMap<Integer, IUPACTable>();
            for (IUPACTable t : this.getTables()) {
                this.nameLookup.put(t.getName(), t);
                this.idLookup.put(t.getId(), t);
            }
        }
    }

    private List<IUPACTable> parseTables() {
        ArrayList<IUPACTable> localTables = new ArrayList<IUPACTable>();
        List<String> lines = IOUtils.getList(this.is);
        Integer id = null;
        String basethree = null;
        String basetwo = null;
        String baseone = null;
        String starts = null;
        String aa = null;
        String name = null;
        for (String line : lines) {
            if (line.equalsIgnoreCase("//")) {
                localTables.add(new IUPACTable(name, id, aa, starts, baseone, basetwo, basethree));
                basethree = null;
                basetwo = null;
                baseone = null;
                starts = null;
                aa = null;
                name = null;
                id = null;
                continue;
            }
            String[] keyValue = line.split("\\s*=\\s*");
            if (keyValue[0].equals("AAs")) {
                aa = keyValue[1];
                continue;
            }
            if (keyValue[0].equals("Starts")) {
                starts = keyValue[1];
                continue;
            }
            if (keyValue[0].equals("Base1")) {
                baseone = keyValue[1];
                continue;
            }
            if (keyValue[0].equals("Base2")) {
                basetwo = keyValue[1];
                continue;
            }
            if (keyValue[0].equals("Base3")) {
                basethree = keyValue[1];
                continue;
            }
            name = keyValue[0];
            id = Integer.parseInt(keyValue[1]);
        }
        return localTables;
    }

    private static class IOD {
        public static final IUPACParser INSTANCE = new IUPACParser();

        private IOD() {
        }
    }

    public static class IUPACTable
    implements Table {
        private final Integer id;
        private final String name;
        private final String aminoAcidString;
        private final String startCodons;
        private final String baseOne;
        private final String baseTwo;
        private final String baseThree;
        private final List<Table.Codon> codons = new ArrayList<Table.Codon>();
        private CompoundSet<Table.Codon> compounds = null;

        public IUPACTable(String name, int id, String aminoAcidString, String startCodons, String baseOne, String baseTwo, String baseThree) {
            this.aminoAcidString = aminoAcidString;
            this.startCodons = startCodons;
            this.name = name;
            this.id = id;
            this.baseOne = baseOne;
            this.baseTwo = baseTwo;
            this.baseThree = baseThree;
        }

        public IUPACTable(String name, Integer id, String aminoAcidString, String startCodons) {
            this(name, id, aminoAcidString, startCodons, "TTTTTTTTTTTTTTTTCCCCCCCCCCCCCCCCAAAAAAAAAAAAAAAAGGGGGGGGGGGGGGGG", "TTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGG", "TCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAG");
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isStart(AminoAcidCompound compound) throws IllegalStateException {
            if (this.codons.isEmpty()) {
                throw new IllegalStateException("Codons are empty; please request getCodons() fist before asking this");
            }
            for (Table.Codon codon : this.codons) {
                if (!codon.isStart() || !codon.getAminoAcid().equalsIgnoreCase(compound)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Table.Codon> getCodons(CompoundSet<NucleotideCompound> nucelotides, CompoundSet<AminoAcidCompound> aminoAcids) {
            if (this.codons.isEmpty()) {
                List<String> aminoAcidStrings = this.aminoAcids();
                List<String> startCodonStrings = this.startCodons();
                List<List<String>> codonStrings = this.codonStrings();
                for (int i = 0; i < aminoAcidStrings.size(); ++i) {
                    List<String> codonString = codonStrings.get(i);
                    NucleotideCompound one = this.getCompound(codonString, 0, nucelotides);
                    NucleotideCompound two = this.getCompound(codonString, 1, nucelotides);
                    NucleotideCompound three = this.getCompound(codonString, 2, nucelotides);
                    boolean start = "M".equals(startCodonStrings.get(i));
                    boolean stop = "*".equals(aminoAcidStrings.get(i));
                    AminoAcidCompound aminoAcid = aminoAcids.getCompoundForString(aminoAcidStrings.get(i));
                    this.codons.add(new Table.Codon(new Table.CaseInsensitiveTriplet(one, two, three), aminoAcid, start, stop));
                }
            }
            return this.codons;
        }

        private NucleotideCompound getCompound(List<String> compounds, int position, CompoundSet<NucleotideCompound> nucelotides) {
            String compound = compounds.get(position);
            NucleotideCompound returnCompound = nucelotides.getCompoundForString(compound);
            if (returnCompound == null) {
                if ("T".equalsIgnoreCase(compound)) {
                    returnCompound = nucelotides.getCompoundForString("U");
                } else {
                    throw new ParserException("Cannot find a compound for string " + compound);
                }
            }
            return returnCompound;
        }

        @Override
        public CompoundSet<Table.Codon> getCodonCompoundSet(final CompoundSet<NucleotideCompound> rnaCompounds, final CompoundSet<AminoAcidCompound> aminoAcidCompounds) {
            if (this.compounds == null) {
                this.compounds = new AbstractCompoundSet<Table.Codon>(){
                    {
                        for (Table.Codon c : this.getCodons(rnaCompounds, aminoAcidCompounds)) {
                            this.addCompound(c);
                        }
                    }
                };
            }
            return this.compounds;
        }

        private List<List<String>> codonStrings() {
            ArrayList<List<String>> codons = new ArrayList<List<String>>();
            for (int i = 0; i < this.baseOne.length(); ++i) {
                List<String> codon = Arrays.asList(Character.toString(this.baseOne.charAt(i)), Character.toString(this.baseTwo.charAt(i)), Character.toString(this.baseThree.charAt(i)));
                codons.add(codon);
            }
            return codons;
        }

        private List<String> aminoAcids() {
            return this.split(this.aminoAcidString);
        }

        private List<String> startCodons() {
            return this.split(this.startCodons);
        }

        private List<String> split(String string) {
            ArrayList<String> split = new ArrayList<String>();
            for (int i = 0; i < string.length(); ++i) {
                split.add(Character.toString(string.charAt(i)));
            }
            return split;
        }
    }
}

